/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mojang.authlib.GameProfile;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.inventory.PostBoxMenu;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSendPackage;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.commons.lang3.StringUtils;

public class PostBoxScreen
extends AbstractContainerScreen<PostBoxMenu> {
    private static final Component MAILBOXES_LABEL = Utils.translation("gui", "mailboxes", new Object[0]);
    private static final ResourceLocation POST_BOX_TEXTURE = Utils.resource("textures/gui/container/post_box.png");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/villager/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/villager/scroller_disabled");
    private static final List<IMailbox> MAILBOX_CACHE = new ArrayList<IMailbox>();
    private static final Map<UUID, PlayerInfo> PLAYER_INFO_CACHE = new HashMap<UUID, PlayerInfo>();
    private static final int SCROLL_SPEED = 5;
    private static final int SCROLL_BAR_WIDTH = 6;
    private static final int SCROLL_BAR_HEIGHT = 27;
    private static final int MAILBOX_ENTRY_WIDTH = 85;
    private static final int MAILBOX_ENTRY_HEIGHT = 14;
    private static final int CONTAINER_LEFT = 8;
    private static final int CONTAINER_TOP = 34;
    private static final int CONTAINER_HEIGHT = 130;
    private static final int CONTAINER_WIDTH = 85;
    private static final int MAX_VISIBLE_ITEMS = Mth.ceil((double)9.285714285714286) + 1;
    protected List<IMailbox> mailboxes = new ArrayList<IMailbox>();
    protected IMailbox selected;
    protected EditBox searchEditBox;
    protected String query = "";
    protected MultiLineEditBox messageEditBox;
    protected Button sendButton;
    protected String message = "";
    protected int scroll;
    protected int clickedY = -1;

    public PostBoxScreen(PostBoxMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, (Component)Component.empty());
        this.imageWidth = 283;
        this.imageHeight = 172;
        this.inventoryLabelX = 113;
        this.inventoryLabelY = this.imageHeight - 93;
        this.updateSearchFilter();
    }

    protected void init() {
        super.init();
        this.searchEditBox = new EditBox(this.font, this.leftPos + 8, this.topPos + 18, 92, 12, (Component)Utils.translation("gui", "search_mailboxes", new Object[0]));
        this.addRenderableWidget((GuiEventListener)this.searchEditBox);
        this.searchEditBox.setHint((Component)Utils.translation("gui", "search", new Object[0]));
        this.searchEditBox.setResponder(s -> {
            this.query = s;
            this.updateSearchFilter();
            this.scroll(0);
        });
        if (!this.query.isBlank()) {
            this.searchEditBox.setValue(this.query);
        }
        this.messageEditBox = new MultiLineEditBox(this, this.font, this.leftPos + 118, this.topPos + 13, 116, 54, (Component)Utils.translation("gui", "enter_message", new Object[0]), (Component)Utils.translation("gui", "package_message", new Object[0])){

            protected void renderBorder(GuiGraphics graphics, int x, int y, int width, int height) {
            }

            protected boolean scrollbarVisible() {
                return false;
            }
        };
        this.addRenderableWidget((GuiEventListener)this.messageEditBox);
        this.messageEditBox.setValueListener(s -> {
            this.message = s;
        });
        if (!this.message.isBlank()) {
            this.messageEditBox.setValue(this.message);
        }
        this.sendButton = new IconButton(this.leftPos + 284, this.topPos + 22, 20, 0, 18, 18, CommonComponents.EMPTY, btn -> {
            if (this.selected != null) {
                Network.getPlay().sendToServer((Object)new MessageSendPackage(this.selected.getId(), this.message));
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
            }
        });
        this.addRenderableWidget((GuiEventListener)this.sendButton);
        this.sendButton.setTooltip(Tooltip.create((Component)Utils.translation("gui", "send", new Object[0])));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.sendButton.active = this.selected != null && !((PostBoxMenu)this.menu).getContainer().isEmpty();
        this.searchEditBox.setTextColor(this.searchEditBox.getValue().isEmpty() && !this.searchEditBox.isFocused() ? 0x707070 : 0xE0E0E0);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        graphics.drawString(this.font, MAILBOXES_LABEL, this.titleLabelX, this.titleLabelY, -2039584, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.blit(POST_BOX_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth + 25, this.imageHeight, 512, 256);
        graphics.enableScissor(this.leftPos + 8, this.topPos + 34, this.leftPos + 8 + 85, this.topPos + 34 + 130);
        int scroll = this.clampScroll(this.scroll + this.getDeltaScroll(mouseY));
        int startIndex = Mth.clamp((int)(scroll / 14), (int)0, (int)Math.max(0, this.mailboxes.size() - 1 - MAX_VISIBLE_ITEMS));
        int maxItems = Math.min(MAX_VISIBLE_ITEMS, this.mailboxes.size());
        for (int i = 0; i < maxItems; ++i) {
            int entryIndex = startIndex + i;
            int entryX = this.leftPos + 8;
            int entryY = this.topPos + 34 + entryIndex * 14 - scroll;
            IMailbox mailbox = this.mailboxes.get(entryIndex);
            boolean selected = this.selected == mailbox;
            graphics.blit(POST_BOX_TEXTURE, entryX, entryY, 0.0f, selected ? 172.0f : 186.0f, 85, 14, 512, 256);
            Optional<GameProfile> optional = mailbox.getOwner();
            if (optional.isPresent()) {
                PlayerInfo info = this.getPlayerInfo(optional.get());
                PlayerFaceRenderer.draw((GuiGraphics)graphics, (PlayerSkin)info.getSkin(), (int)(entryX + 3), (int)(entryY + 3), (int)8);
            }
            String mailboxName = mailbox.getCustomName().orElse("Mailbox");
            graphics.drawString(this.font, mailboxName, entryX + 15, entryY + 3, selected ? -171 : -1);
            if (!this.isHovering(entryX - this.leftPos + 3, entryY - this.topPos + 3, 8, 8, mouseX, mouseY)) continue;
            String ownerName = mailbox.getOwner().map(GameProfile::getName).orElse("Unknown Player");
            this.setTooltipForNextRenderPass((Component)Component.literal((String)ownerName));
        }
        graphics.disableScissor();
        graphics.blitSprite(this.canScroll() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE, this.leftPos + 8 + 85 + 1, this.topPos + 34 + this.getScrollBarOffset(mouseY), 6, 27);
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 2; ++i) {
                if (!((PostBoxMenu)this.menu).getContainer().getItem(j * 2 + i).isEmpty()) continue;
                graphics.blit(POST_BOX_TEXTURE, this.leftPos + 235 + i * 18, this.topPos + 14 + j * 18, 85.0f, 172.0f, 16, 16, 512, 256);
            }
        }
        if (this.isHovering(91, 5, 10, 10, mouseX, mouseY)) {
            this.setTooltipForNextRenderPass(ScreenHelper.createMultilineTooltip(List.of(Utils.translation("gui", "how_to", new Object[0]).withStyle(ChatFormatting.GOLD), Utils.translation("gui", "post_box_info", new Object[0]))).toCharSequence(this.minecraft));
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int relativeMouseY;
            int clickedIndex;
            this.setFocused(null);
            if (this.isHovering(8, 34, 85, 130, mouseX, mouseY) && (clickedIndex = (this.scroll + (relativeMouseY = (int)(mouseY - (double)this.topPos - 34.0))) / 14) >= 0 && clickedIndex < this.mailboxes.size()) {
                IMailbox mailbox = this.mailboxes.get(clickedIndex);
                this.selected = this.selected != mailbox ? mailbox : null;
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PUT, (float)1.0f, (float)1.0f));
                this.sendButton.active = this.selected != null;
                return true;
            }
            if (this.isHovering(94, 34 + this.getScrollBarOffset((int)mouseY), 6, 27, mouseX, mouseY)) {
                this.clickedY = (int)mouseY;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.clickedY >= 0) {
            this.scroll(this.getDeltaScroll((int)mouseY));
            this.clickedY = -1;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.searchEditBox.isFocused()) {
            return this.searchEditBox.keyPressed(key, scanCode, modifiers);
        }
        if (this.messageEditBox.isFocused()) {
            return this.messageEditBox.keyPressed(key, scanCode, modifiers);
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isHovering(8, 34, 85, 130, mouseX, mouseY)) {
            this.scroll((int)(-5.0 * deltaY));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private void scroll(int amount) {
        this.scroll = this.clampScroll(this.scroll + amount);
    }

    private int clampScroll(int scroll) {
        return Mth.clamp((int)scroll, (int)0, (int)this.getMaxScroll());
    }

    private int getMaxScroll() {
        return Math.max(this.mailboxes.size() * 14 - 130, 0);
    }

    private boolean canScroll() {
        return this.getMaxScroll() > 0;
    }

    private int getScrollBarOffset(int mouseY) {
        int scroll = this.clampScroll(this.scroll + this.getDeltaScroll(mouseY));
        return (int)(103.0 * ((double)scroll / (double)this.getMaxScroll()));
    }

    private int getDeltaScroll(int mouseY) {
        if (this.clickedY != -1) {
            double pixelsPerScroll = 103.0 / (double)this.getMaxScroll();
            return (int)((double)(mouseY - this.clickedY) / pixelsPerScroll);
        }
        return 0;
    }

    private void updateSearchFilter() {
        List<IMailbox> filteredMailboxes = MAILBOX_CACHE.stream().filter(mailbox -> {
            if (this.query.startsWith("@")) {
                String ownerName = mailbox.getOwner().map(GameProfile::getName).orElse("Unknown");
                return StringUtils.containsIgnoreCase((CharSequence)ownerName, (CharSequence)this.query.substring(1));
            }
            String mailboxName = mailbox.getCustomName().orElse("Mailbox");
            return StringUtils.containsIgnoreCase((CharSequence)mailboxName, (CharSequence)this.query);
        }).sorted(Comparator.comparing(mailbox -> mailbox.getOwner().map(GameProfile::getName).orElse("Unknown")).thenComparing(mailbox -> mailbox.getCustomName().orElse("Mailbox"))).toList();
        this.mailboxes.clear();
        this.mailboxes.addAll(filteredMailboxes);
    }

    private PlayerInfo getPlayerInfo(GameProfile profile) {
        PlayerInfo info;
        ClientPacketListener listener;
        if (this.minecraft != null && (listener = this.minecraft.getConnection()) != null && (info = listener.getPlayerInfo(profile.getId())) != null) {
            return info;
        }
        return PLAYER_INFO_CACHE.computeIfAbsent(profile.getId(), uuid -> new PlayerInfo(profile, false));
    }

    public void clearMessage() {
        this.messageEditBox.setValue("");
    }

    public static void updateMailboxes(Collection<? extends IMailbox> mailboxes) {
        MAILBOX_CACHE.clear();
        MAILBOX_CACHE.addAll(mailboxes);
    }
}

