/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.IPaintable;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModDataComponents;
import com.mrcrayfish.furniture.refurbished.image.PaletteImage;
import com.mrcrayfish.furniture.refurbished.inventory.DoorMatMenu;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DoorMatBlockEntity
extends BlockEntity
implements MenuProvider,
IPaintable {
    public static final int IMAGE_WIDTH = 14;
    public static final int IMAGE_HEIGHT = 10;
    @Nullable
    private Player paintingPlayer;
    @Nullable
    private PaletteImage image;
    private boolean finalised;

    public DoorMatBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DOOR_MAT.get(), pos, state);
    }

    @Override
    public void setImage(PaletteImage image) {
        if (image.getWidth() == 14 && image.getHeight() == 10) {
            this.image = image;
            this.setChanged();
            if (this.level != null) {
                BlockEntityHelper.sendCustomUpdate(this, BlockEntity::getUpdateTag);
            }
        }
    }

    @Override
    public PaletteImage getImage() {
        return this.image;
    }

    @Override
    @Nullable
    public Player getPainter() {
        return this.paintingPlayer;
    }

    @Override
    public void setPainter(@Nullable Player player) {
        this.paintingPlayer = player;
    }

    @Override
    public boolean isEditable() {
        return !this.finalised;
    }

    @Override
    public void setEditable(boolean state) {
        if (!this.finalised && !state) {
            this.finalised = true;
            this.setChanged();
        }
    }

    @Override
    public boolean isValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player) && player.equals((Object)this.getPainter());
    }

    public Component getDisplayName() {
        return Utils.translation("container", "door_mat", new Object[0]);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new DoorMatMenu(windowId, playerInventory, this);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        PaletteImage image = (PaletteImage)input.get((DataComponentType)ModDataComponents.PALETTE_IMAGE.get());
        if (image != null) {
            this.setImage(image);
            this.finalised = true;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        if (this.image != null) {
            builder.set((DataComponentType)ModDataComponents.PALETTE_IMAGE.get(), (Object)this.image.copy());
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("Image");
        tag.remove("Finalised");
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("Finalised", 1)) {
            this.finalised = tag.getBoolean("Finalised");
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("Finalised", this.finalised);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }
}

