/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.worldgen.feature.BOPVegetationFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;

public class CloverBlock
extends PinkPetalsBlock {
    public CloverBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return (double)rand.nextFloat() < 0.4;
    }

    public void performBonemeal(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        int i = (Integer)state.getValue((Property)AMOUNT);
        if (i < 4) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AMOUNT, (Comparable)Integer.valueOf(i + 1)), 2);
        } else {
            this.growHugeClover(level, rand, pos, state);
        }
    }

    public boolean growHugeClover(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        level.removeBlock(pos, false);
        Registry configuredFeatureRegistry = level.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE);
        ConfiguredFeature configuredfeature = (ConfiguredFeature)configuredFeatureRegistry.get(BOPVegetationFeatures.HUGE_CLOVER);
        if (configuredfeature.place((WorldGenLevel)level, level.getChunkSource().getGenerator(), rand, pos)) {
            return true;
        }
        level.setBlock(pos, state, 3);
        return false;
    }
}

