/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.sounds;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SoundLoopTileentity
extends AbstractTickableSoundInstance {
    protected Level world;
    protected BlockPos pos;

    public SoundLoopTileentity(SoundEvent event, SoundSource category, BlockEntity tileEntity) {
        super(event, category, SoundInstance.createUnseededRandom());
        this.world = tileEntity.getLevel();
        this.pos = tileEntity.getBlockPos();
        this.looping = true;
        this.delay = 0;
        this.x = this.pos.getX();
        this.y = this.pos.getY();
        this.z = this.pos.getZ();
        this.volume = 0.15f;
        this.pitch = 1.0f;
    }

    public void tick() {
        LocalPlayer player;
        if (this.isStopped()) {
            return;
        }
        BlockEntity tileEntity = this.getTileEntity();
        if (tileEntity == null || tileEntity.getLevel() == null) {
            this.stop();
            return;
        }
        if (tileEntity.getLevel().isClientSide && ((player = Minecraft.getInstance().player) == null || !player.isAlive())) {
            this.stop();
            return;
        }
        if (!(tileEntity instanceof ISoundLoopable)) {
            this.stop();
            return;
        }
        ISoundLoopable loop = (ISoundLoopable)tileEntity;
        if (!loop.shouldSoundBePlayed()) {
            this.stop();
            return;
        }
    }

    public BlockEntity getTileEntity() {
        return this.world.getBlockEntity(this.pos);
    }

    public static interface ISoundLoopable {
        public boolean shouldSoundBePlayed();

        public void play();
    }
}

