/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.corelib.net.Message;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageCrash
implements Message<MessageCrash> {
    public static final CustomPacketPayload.Type<MessageCrash> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"crash"));
    private float speed;
    private UUID uuid;

    public MessageCrash() {
    }

    public MessageCrash(float speed, EntityCarBase car) {
        this.speed = speed;
        this.uuid = car.getUUID();
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        Entity entity = sender.getVehicle();
        if (!(entity instanceof EntityCarBase)) {
            return;
        }
        EntityCarBase car = (EntityCarBase)entity;
        if (!car.getUUID().equals(this.uuid)) {
            return;
        }
        car.onCollision(this.speed);
    }

    @Override
    public MessageCrash fromBytes(RegistryFriendlyByteBuf buf) {
        this.speed = buf.readFloat();
        this.uuid = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeFloat(this.speed);
        buf.writeUUID(this.uuid);
    }

    @Override
    public CustomPacketPayload.Type<MessageCrash> type() {
        return TYPE;
    }
}

