/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerLicensePlate;
import de.maxhenkel.car.items.ItemLicensePlate;
import de.maxhenkel.car.net.MessageEditLicensePlate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class GuiLicensePlate
extends ScreenBase<ContainerLicensePlate> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/gui_license_plate.png");
    private static final int TITLE_COLOR = ChatFormatting.WHITE.getColor();
    private ContainerLicensePlate containerLicensePlate;
    private Player player;
    private EditBox textField;

    public GuiLicensePlate(ContainerLicensePlate containerLicensePlate, Inventory playerInventory, Component title) {
        super(GUI_TEXTURE, containerLicensePlate, playerInventory, title);
        this.containerLicensePlate = containerLicensePlate;
        this.player = playerInventory.player;
        this.imageWidth = 176;
        this.imageHeight = 84;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.car.submit"), button -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageEditLicensePlate(this.player, this.textField.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            MessageEditLicensePlate.setItemText(this.player, this.textField.getValue());
            Minecraft.getInstance().setScreen(null);
        }).bounds(this.leftPos + 20, this.topPos + this.imageHeight - 25, 50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.car.cancel"), button -> Minecraft.getInstance().setScreen(null)).bounds(this.leftPos + this.imageWidth - 50 - 15, this.topPos + this.imageHeight - 25, 50, 20).build());
        this.textField = new EditBox(this.font, this.leftPos + 30, this.topPos + 30, 116, 16, (Component)Component.empty());
        this.textField.setTextColor(-1);
        this.textField.setTextColorUneditable(-1);
        this.textField.setBordered(true);
        this.textField.setMaxLength(10);
        this.textField.setValue(ItemLicensePlate.getText(this.containerLicensePlate.getLicensePlate()));
        this.addRenderableWidget((GuiEventListener)this.textField);
        this.setInitialFocus((GuiEventListener)this.textField);
    }

    public void resize(Minecraft mc, int x, int y) {
        String text = this.textField.getValue();
        this.init(mc, x, y);
        this.textField.setValue(text);
    }

    public boolean keyPressed(int key, int a, int b) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return this.textField.keyPressed(key, a, b) || this.textField.canConsumeInput() || super.keyPressed(key, a, b);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawCenteredString(this.font, this.containerLicensePlate.getLicensePlate().getHoverName().getString(), this.imageWidth / 2, 5, TITLE_COLOR);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

