/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityFluidExtractor;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerFluidExtractor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class GuiFluidExtractor
extends ScreenBase<ContainerFluidExtractor> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/gui_fluid_extractor.png");
    private Inventory playerInv;
    private TileEntityFluidExtractor tile;

    public GuiFluidExtractor(ContainerFluidExtractor container, Inventory player, Component title) {
        super(GUI_TEXTURE, container, player, title);
        this.playerInv = player;
        this.tile = container.getTile();
        this.imageWidth = 176;
        this.imageHeight = 139;
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.playerInv.getDisplayName().getVisualOrderText(), 8, this.imageHeight - 96 + 2, 0x404040, false);
        guiGraphics.drawString(this.font, this.tile.getDisplayName().getVisualOrderText(), 8, 6, 0x404040, false);
        this.drawFilter(guiGraphics);
    }

    private void drawFilter(GuiGraphics guiGraphics) {
        this.tile.setFilter(((ContainerFluidExtractor)this.menu).getFilter());
        Fluid f = this.tile.getFilterFluid();
        MutableComponent name = f == null ? Component.literal((String)"-") : Component.literal((String)new FluidStack(f, 1).getHoverName().getString());
        guiGraphics.drawString(this.font, Component.translatable((String)"filter.fluid", (Object[])new Object[]{name.withStyle(ChatFormatting.WHITE)}).getVisualOrderText(), 46, 28, 0x404040, false);
    }
}

