/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityCarInventoryBase;
import de.maxhenkel.car.gui.ContainerCar;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class GuiCar
extends ScreenBase<ContainerCar> {
    private static final ResourceLocation CAR_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/gui_car.png");
    private static final int fontColor = 0x404040;
    private Inventory playerInv;
    private EntityCarInventoryBase car;

    public GuiCar(ContainerCar containerCar, Inventory playerInv, Component title) {
        super(CAR_GUI_TEXTURE, containerCar, playerInv, title);
        this.playerInv = playerInv;
        this.car = containerCar.getCar();
        this.imageWidth = 176;
        this.imageHeight = 248;
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.car.getDisplayName().getVisualOrderText(), 7, 87, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInv.getDisplayName().getVisualOrderText(), 8, this.imageHeight - 96 + 2, 0x404040, false);
        guiGraphics.drawString(this.font, this.getFuelString().getVisualOrderText(), 7, 9, 0x404040, false);
        guiGraphics.drawString(this.font, this.getDamageString().getVisualOrderText(), 7, 35, 0x404040, false);
        guiGraphics.drawString(this.font, this.getBatteryString().getVisualOrderText(), 95, 9, 0x404040, false);
        guiGraphics.drawString(this.font, this.getTempString().getVisualOrderText(), 95, 35, 0x404040, false);
    }

    public float getFuelPercent() {
        float fuelPerc = (float)this.car.getFuelAmount() / (float)this.car.getMaxFuel() * 100.0f;
        return MathUtils.round(fuelPerc, 2);
    }

    public int getBatteryPercent() {
        return (int)(this.car.getBatteryPercentage() * 100.0f);
    }

    public float getTemperatureCelsius() {
        return MathUtils.round(this.car.getTemperature(), 2);
    }

    public float getTemperatureFarenheit() {
        return MathUtils.round(this.car.getTemperature() * 1.8f + 32.0f, 2);
    }

    public float getTemperaturePercent() {
        float temp = this.car.getTemperature();
        if (temp > 100.0f) {
            temp = 100.0f;
        }
        if (temp < 0.0f) {
            temp = 0.0f;
        }
        return temp / 100.0f;
    }

    public float getDamagePercent() {
        float dmg = this.car.getDamage();
        dmg = Math.min(dmg, 100.0f);
        return MathUtils.round(dmg, 2);
    }

    public Component getFuelString() {
        return Component.translatable((String)"gui.car_fuel", (Object[])new Object[]{String.valueOf(this.getFuelPercent())});
    }

    public Component getDamageString() {
        return Component.translatable((String)"gui.car_damage", (Object[])new Object[]{String.valueOf(this.getDamagePercent())});
    }

    public Component getBatteryString() {
        return Component.translatable((String)"gui.car_battery", (Object[])new Object[]{String.valueOf(this.getBatteryPercent())});
    }

    public Component getTempString() {
        if (((Boolean)Main.CLIENT_CONFIG.tempInFarenheit.get()).booleanValue()) {
            return Component.translatable((String)"gui.car_temperature_fahrenheit", (Object[])new Object[]{String.valueOf(this.getTemperatureFarenheit())});
        }
        return Component.translatable((String)"gui.car_temperature_celsius", (Object[])new Object[]{String.valueOf(this.getTemperatureCelsius())});
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawFuel(guiGraphics, this.getFuelPercent());
        this.drawDamage(guiGraphics, 100.0f - this.getDamagePercent());
        this.drawBattery(guiGraphics, this.car.getBatteryPercentage());
        this.drawTemp(guiGraphics, this.getTemperaturePercent());
    }

    public void drawFuel(GuiGraphics guiGraphics, float percent) {
        percent = Math.min(100.0f, percent);
        int scaled = (int)((double)(72.0f * percent) / 100.0);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(CAR_GUI_TEXTURE, i + 8, j + 20, 176, 0, scaled, 10);
    }

    public void drawDamage(GuiGraphics guiGraphics, float percent) {
        percent = Math.min(100.0f, percent);
        int scaled = (int)((double)(72.0f * percent) / 100.0);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(CAR_GUI_TEXTURE, i + 8, j + 46, 176, 10, scaled, 10);
    }

    public void drawTemp(GuiGraphics guiGraphics, float percent) {
        percent = Math.min(100.0f, percent);
        int scaled = (int)(72.0f * percent);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(CAR_GUI_TEXTURE, i + 96, j + 46, 176, 30, scaled, 10);
    }

    public void drawBattery(GuiGraphics guiGraphics, float percent) {
        percent = Math.min(100.0f, percent);
        int scaled = (int)(72.0f * percent);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(CAR_GUI_TEXTURE, i + 96, j + 20, 176, 20, scaled, 10);
    }
}

