/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.level.biome.Climate;

public class ParameterUtils {

    public static enum Weirdness {
        MID_SLICE_NORMAL_ASCENDING(Climate.Parameter.span((float)-1.0f, (float)-0.93333334f)),
        HIGH_SLICE_NORMAL_ASCENDING(Climate.Parameter.span((float)-0.93333334f, (float)-0.7666667f)),
        PEAK_NORMAL(Climate.Parameter.span((float)-0.7666667f, (float)-0.56666666f)),
        HIGH_SLICE_NORMAL_DESCENDING(Climate.Parameter.span((float)-0.56666666f, (float)-0.4f)),
        MID_SLICE_NORMAL_DESCENDING(Climate.Parameter.span((float)-0.4f, (float)-0.26666668f)),
        LOW_SLICE_NORMAL_DESCENDING(Climate.Parameter.span((float)-0.26666668f, (float)-0.05f)),
        VALLEY(Climate.Parameter.span((float)-0.05f, (float)0.05f)),
        LOW_SLICE_VARIANT_ASCENDING(Climate.Parameter.span((float)0.05f, (float)0.26666668f)),
        MID_SLICE_VARIANT_ASCENDING(Climate.Parameter.span((float)0.26666668f, (float)0.4f)),
        HIGH_SLICE_VARIANT_ASCENDING(Climate.Parameter.span((float)0.4f, (float)0.56666666f)),
        PEAK_VARIANT(Climate.Parameter.span((float)0.56666666f, (float)0.7666667f)),
        HIGH_SLICE_VARIANT_DESCENDING(Climate.Parameter.span((float)0.7666667f, (float)0.93333334f)),
        MID_SLICE_VARIANT_DESCENDING(Climate.Parameter.span((float)0.93333334f, (float)1.0f)),
        FULL_RANGE(Climate.Parameter.span((float)-1.0f, (float)1.0f));

        private final Climate.Parameter parameter;

        private Weirdness(Climate.Parameter parameter) {
            this.parameter = parameter;
        }

        public Climate.Parameter parameter() {
            return this.parameter;
        }

        public static Climate.Parameter span(Weirdness min, Weirdness max) {
            return Climate.Parameter.span((float)Climate.unquantizeCoord((long)min.parameter().min()), (float)Climate.unquantizeCoord((long)max.parameter().max()));
        }
    }

    public static enum Depth {
        SURFACE(Climate.Parameter.point((float)0.0f)),
        UNDERGROUND(Climate.Parameter.span((float)0.2f, (float)0.9f)),
        FLOOR(Climate.Parameter.point((float)1.0f)),
        FULL_RANGE(Climate.Parameter.span((float)-1.0f, (float)1.0f));

        private final Climate.Parameter parameter;

        private Depth(Climate.Parameter parameter) {
            this.parameter = parameter;
        }

        public Climate.Parameter parameter() {
            return this.parameter;
        }

        public static Climate.Parameter span(Depth min, Depth max) {
            return Climate.Parameter.span((float)Climate.unquantizeCoord((long)min.parameter().min()), (float)Climate.unquantizeCoord((long)max.parameter().max()));
        }
    }

    public static enum Erosion {
        EROSION_0(Climate.Parameter.span((float)-1.0f, (float)-0.78f)),
        EROSION_1(Climate.Parameter.span((float)-0.78f, (float)-0.375f)),
        EROSION_2(Climate.Parameter.span((float)-0.375f, (float)-0.2225f)),
        EROSION_3(Climate.Parameter.span((float)-0.2225f, (float)0.05f)),
        EROSION_4(Climate.Parameter.span((float)0.05f, (float)0.45f)),
        EROSION_5(Climate.Parameter.span((float)0.45f, (float)0.55f)),
        EROSION_6(Climate.Parameter.span((float)0.55f, (float)1.0f)),
        FULL_RANGE(Climate.Parameter.span((float)-1.0f, (float)1.0f));

        private final Climate.Parameter parameter;

        private Erosion(Climate.Parameter parameter) {
            this.parameter = parameter;
        }

        public Climate.Parameter parameter() {
            return this.parameter;
        }

        public static Climate.Parameter span(Erosion min, Erosion max) {
            return Climate.Parameter.span((float)Climate.unquantizeCoord((long)min.parameter().min()), (float)Climate.unquantizeCoord((long)max.parameter().max()));
        }
    }

    public static enum Continentalness {
        MUSHROOM_FIELDS(Climate.Parameter.span((float)-1.2f, (float)-1.05f)),
        DEEP_OCEAN(Climate.Parameter.span((float)-1.05f, (float)-0.455f)),
        OCEAN(Climate.Parameter.span((float)-0.455f, (float)-0.19f)),
        COAST(Climate.Parameter.span((float)-0.19f, (float)-0.11f)),
        NEAR_INLAND(Climate.Parameter.span((float)-0.11f, (float)0.03f)),
        MID_INLAND(Climate.Parameter.span((float)0.03f, (float)0.3f)),
        FAR_INLAND(Climate.Parameter.span((float)0.3f, (float)1.0f)),
        INLAND(Climate.Parameter.span((float)-0.11f, (float)0.55f)),
        FULL_RANGE(Climate.Parameter.span((float)-1.0f, (float)1.0f));

        private final Climate.Parameter parameter;

        private Continentalness(Climate.Parameter parameter) {
            this.parameter = parameter;
        }

        public Climate.Parameter parameter() {
            return this.parameter;
        }

        public static Climate.Parameter span(Continentalness min, Continentalness max) {
            return Climate.Parameter.span((float)Climate.unquantizeCoord((long)min.parameter().min()), (float)Climate.unquantizeCoord((long)max.parameter().max()));
        }
    }

    public static enum Humidity {
        ARID(Climate.Parameter.span((float)-1.0f, (float)-0.35f)),
        DRY(Climate.Parameter.span((float)-0.35f, (float)-0.1f)),
        NEUTRAL(Climate.Parameter.span((float)-0.1f, (float)0.1f)),
        WET(Climate.Parameter.span((float)0.1f, (float)0.3f)),
        HUMID(Climate.Parameter.span((float)0.3f, (float)1.0f)),
        FULL_RANGE(Climate.Parameter.span((float)-1.0f, (float)1.0f));

        private final Climate.Parameter parameter;

        private Humidity(Climate.Parameter parameter) {
            this.parameter = parameter;
        }

        public Climate.Parameter parameter() {
            return this.parameter;
        }

        public static Climate.Parameter span(Humidity min, Humidity max) {
            return Climate.Parameter.span((float)Climate.unquantizeCoord((long)min.parameter().min()), (float)Climate.unquantizeCoord((long)max.parameter().max()));
        }
    }

    public static enum Temperature {
        ICY(Climate.Parameter.span((float)-1.0f, (float)-0.45f)),
        COOL(Climate.Parameter.span((float)-0.45f, (float)-0.15f)),
        NEUTRAL(Climate.Parameter.span((float)-0.15f, (float)0.2f)),
        WARM(Climate.Parameter.span((float)0.2f, (float)0.55f)),
        HOT(Climate.Parameter.span((float)0.55f, (float)1.0f)),
        FROZEN(Climate.Parameter.span((float)-1.0f, (float)-0.45f)),
        UNFROZEN(Climate.Parameter.span((float)-0.45f, (float)1.0f)),
        FULL_RANGE(Climate.Parameter.span((float)-1.0f, (float)1.0f));

        private final Climate.Parameter parameter;

        private Temperature(Climate.Parameter parameter) {
            this.parameter = parameter;
        }

        public Climate.Parameter parameter() {
            return this.parameter;
        }

        public static Climate.Parameter span(Temperature min, Temperature max) {
            return Climate.Parameter.span((float)Climate.unquantizeCoord((long)min.parameter().min()), (float)Climate.unquantizeCoord((long)max.parameter().max()));
        }
    }

    public static class ParameterPointListBuilder {
        private List<Climate.Parameter> temperatures = Lists.newArrayList();
        private List<Climate.Parameter> humidities = Lists.newArrayList();
        private List<Climate.Parameter> continentalnesses = Lists.newArrayList();
        private List<Climate.Parameter> erosions = Lists.newArrayList();
        private List<Climate.Parameter> depths = Lists.newArrayList();
        private List<Climate.Parameter> weirdnesses = Lists.newArrayList();
        private List<Long> offsets = Lists.newArrayList();

        public ParameterPointListBuilder temperature(Climate.Parameter ... values) {
            this.temperatures.addAll(Arrays.asList(values));
            return this;
        }

        public ParameterPointListBuilder temperature(Temperature ... values) {
            this.temperatures.addAll(Arrays.asList(values).stream().map(Temperature::parameter).toList());
            return this;
        }

        public ParameterPointListBuilder humidity(Climate.Parameter ... values) {
            this.humidities.addAll(Arrays.asList(values));
            return this;
        }

        public ParameterPointListBuilder humidity(Humidity ... values) {
            this.humidities.addAll(Arrays.asList(values).stream().map(Humidity::parameter).toList());
            return this;
        }

        public ParameterPointListBuilder continentalness(Climate.Parameter ... values) {
            this.continentalnesses.addAll(Arrays.asList(values));
            return this;
        }

        public ParameterPointListBuilder continentalness(Continentalness ... values) {
            this.continentalnesses.addAll(Arrays.asList(values).stream().map(Continentalness::parameter).toList());
            return this;
        }

        public ParameterPointListBuilder erosion(Climate.Parameter ... values) {
            this.erosions.addAll(Arrays.asList(values));
            return this;
        }

        public ParameterPointListBuilder erosion(Erosion ... values) {
            this.erosions.addAll(Arrays.asList(values).stream().map(Erosion::parameter).toList());
            return this;
        }

        public ParameterPointListBuilder depth(Climate.Parameter ... values) {
            this.depths.addAll(Arrays.asList(values));
            return this;
        }

        public ParameterPointListBuilder depth(Depth ... values) {
            this.depths.addAll(Arrays.asList(values).stream().map(Depth::parameter).toList());
            return this;
        }

        public ParameterPointListBuilder weirdness(Climate.Parameter ... values) {
            this.weirdnesses.addAll(Arrays.asList(values));
            return this;
        }

        public ParameterPointListBuilder weirdness(Weirdness ... values) {
            this.weirdnesses.addAll(Arrays.asList(values).stream().map(Weirdness::parameter).toList());
            return this;
        }

        public ParameterPointListBuilder offset(Float ... values) {
            this.offsets.addAll(Arrays.asList(values).stream().map(Climate::quantizeCoord).toList());
            return this;
        }

        public ParameterPointListBuilder offset(Long ... values) {
            this.offsets.addAll(Arrays.asList(values));
            return this;
        }

        public List<Climate.ParameterPoint> build() {
            this.populateIfEmpty();
            ImmutableList.Builder builder = new ImmutableList.Builder();
            this.temperatures.forEach(temperature -> this.humidities.forEach(humidity -> this.continentalnesses.forEach(continentalness -> this.erosions.forEach(erosion -> this.depths.forEach(depth -> this.weirdnesses.forEach(weirdness -> this.offsets.forEach(offset -> builder.add((Object)new Climate.ParameterPoint(temperature, humidity, continentalness, erosion, depth, weirdness, offset.longValue())))))))));
            return builder.build();
        }

        private void populateIfEmpty() {
            if (this.temperatures.isEmpty()) {
                this.temperatures.add(Temperature.FULL_RANGE.parameter());
            }
            if (this.humidities.isEmpty()) {
                this.humidities.add(Humidity.FULL_RANGE.parameter());
            }
            if (this.continentalnesses.isEmpty()) {
                this.continentalnesses.add(Continentalness.FULL_RANGE.parameter());
            }
            if (this.erosions.isEmpty()) {
                this.erosions.add(Erosion.FULL_RANGE.parameter());
            }
            if (this.depths.isEmpty()) {
                this.depths.add(Depth.FULL_RANGE.parameter());
            }
            if (this.weirdnesses.isEmpty()) {
                this.weirdnesses.add(Weirdness.FULL_RANGE.parameter());
            }
            if (this.offsets.isEmpty()) {
                this.offsets.add(Climate.quantizeCoord((float)0.0f));
            }
        }
    }
}

