/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.integration.waila;

import de.maxhenkel.plane.corelib.math.MathUtils;
import de.maxhenkel.plane.entity.EntityPlane;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class HUDHandlerPlanes
implements IEntityComponentProvider {
    public static final ResourceLocation OBJECT_NAME_TAG = ResourceLocation.fromNamespaceAndPath((String)"jade", (String)"object_name");
    public static final HUDHandlerPlanes INSTANCE = new HUDHandlerPlanes();
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"plane");

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof EntityPlane) {
            EntityPlane plane = (EntityPlane)entity;
            iTooltip.remove(OBJECT_NAME_TAG);
            iTooltip.add((Component)entityAccessor.getEntity().getDisplayName().copy().withStyle(ChatFormatting.WHITE));
            iTooltip.add((Component)Component.translatable((String)"tooltip.plane.fuel", (Object[])new Object[]{Component.literal((String)String.valueOf(plane.getFuel())).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
            iTooltip.add((Component)Component.translatable((String)"tooltip.plane.damage", (Object[])new Object[]{Component.literal((String)String.valueOf(MathUtils.round(plane.getPlaneDamage(), 2))).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

