/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.plane.corelib.client.obj.OBJEntityRenderer;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public abstract class AbstractPlaneModel<T extends EntityPlaneSoundBase>
extends OBJEntityRenderer<T> {
    protected AbstractPlaneModel(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    @Override
    public void render(T plane, float yRot, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int light) {
        super.render(plane, yRot, partialTicks, matrixStack, buffer, light);
        if (plane.hasCustomName()) {
            String name = this.trimName(plane.getCustomName().getString(), 0.02f, 1.0f);
            this.drawName(plane, name, matrixStack, buffer, partialTicks, yRot, light, true);
            this.drawName(plane, name, matrixStack, buffer, partialTicks, yRot, light, false);
        }
    }

    protected String trimName(String name, float textScale, float maxLength) {
        while ((float)this.getFont().width(name) * textScale > maxLength) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    protected void drawName(T plane, String txt, PoseStack matrixStack, MultiBufferSource buffer, float partialTicks, float yRot, int light, boolean left) {
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(-yRot));
        float xRot = ((EntityPlaneSoundBase)((Object)plane)).xRotO + (plane.getXRot() - ((EntityPlaneSoundBase)((Object)plane)).xRotO) * partialTicks;
        matrixStack.mulPose(Axis.XP.rotationDegrees(xRot));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.scale(1.0f, -1.0f, 1.0f);
        this.translateName(plane, matrixStack, left);
        int textWidth = this.getFont().width(txt);
        float textScale = 0.02f;
        matrixStack.translate(-(textScale * (float)textWidth) / 2.0f, 0.0f, 0.0f);
        matrixStack.scale(textScale, textScale, textScale);
        this.getFont().drawInBatch(txt, 0.0f, 0.0f, 0xFFFFFF, false, matrixStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, light);
        matrixStack.popPose();
    }

    protected abstract void translateName(T var1, PoseStack var2, boolean var3);
}

