/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.entity.EntityPlaneDamageBase;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.net.MessageControlPlane;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class EntityPlaneControlBase
extends EntityPlaneDamageBase {
    private static final EntityDataAccessor<Float> ENGINE_SPEED = SynchedEntityData.defineId(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> STARTED = SynchedEntityData.defineId(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> START_TIME = SynchedEntityData.defineId(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> THRUST_POSITIVE = SynchedEntityData.defineId(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> THRUST_NEGATIVE = SynchedEntityData.defineId(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LEFT = SynchedEntityData.defineId(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> RIGHT = SynchedEntityData.defineId(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> UP = SynchedEntityData.defineId(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DOWN = SynchedEntityData.defineId(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BRAKE = SynchedEntityData.defineId(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final double MAX_ENGINE_SPEED = 1.5;
    public static final double ENGINE_ACCELERATION = 0.005;
    public static final double BRAKE_POWER = 0.012;
    private boolean onGroundLast;
    private boolean onGroundLast2;

    public EntityPlaneControlBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getStartTime() > this.getTimeToStart() && !this.isStarted() && this.canEngineBeStarted()) {
            this.setStarted(true);
        }
        if (this.isStarted() && !this.canEngineBeStarted()) {
            this.setStarted(false);
        }
        if (!this.level().isClientSide) {
            if (this.isStarted()) {
                if (this.isThrustPositive()) {
                    this.setEngineSpeed(Math.min(this.getEngineSpeed() + 0.025f, 1.0f));
                } else if (this.isThrustNegative()) {
                    this.setEngineSpeed(Math.max(this.getEngineSpeed() - 0.025f, 0.0f));
                }
            } else {
                this.setEngineSpeed(0.0f);
            }
        }
        this.controlPlane();
        this.handleRotation();
    }

    public boolean canEngineBeStarted() {
        return !this.isStarted() || !(this.getPlaneDamage() >= 100.0f);
    }

    public int getTimeToStart() {
        int time = 40;
        time = (int)((float)time + (float)((int)this.getPlaneDamage()) / 2.0f);
        return time;
    }

    private void handleRotation() {
        double speed = this.getDeltaMovement().length();
        float rotationSpeed = 0.0f;
        if (Math.abs(speed) > 0.0) {
            rotationSpeed = Mth.abs((float)(0.5f / (float)Math.pow(speed, 2.0)));
            rotationSpeed = Mth.clamp((float)rotationSpeed, (float)1.0f, (float)5.0f);
        }
        this.deltaRotation = 0.0f;
        rotationSpeed = Math.abs(rotationSpeed);
        if (this.isLeft()) {
            this.deltaRotation -= rotationSpeed;
        }
        if (this.isRight()) {
            this.deltaRotation += rotationSpeed;
        }
        this.setYRot(this.getYRot() + this.deltaRotation);
        float delta = Math.abs(this.getYRot() - this.yRotO);
        while (this.getYRot() > 180.0f) {
            this.setYRot(this.getYRot() - 360.0f);
            this.yRotO = this.getYRot() - delta;
        }
        while (this.getYRot() <= -180.0f) {
            this.setYRot(this.getYRot() + 360.0f);
            this.yRotO = delta + this.getYRot();
        }
        if (this.isUp()) {
            this.setXRot(this.getXRot() - 1.0f);
        } else if (this.isDown()) {
            this.setXRot(this.getXRot() + 1.0f);
        }
        this.setXRot(Math.max(this.getXRot(), -90.0f));
        this.setXRot(Math.min(this.getXRot(), 90.0f));
        float groundPitchTolerance = 7.0f;
        if (this.isCollidedVertical()) {
            if (this.getXRot() > 0.0f) {
                this.setXRot(this.getXRot() - 10.0f);
                if (this.getXRot() < 0.0f) {
                    this.setXRot(0.0f);
                }
            }
            if (this.getXRot() < -groundPitchTolerance) {
                this.setXRot(this.getXRot() + 10.0f);
                if (this.getXRot() > -groundPitchTolerance) {
                    this.setXRot(this.getXRot() - groundPitchTolerance);
                }
            }
        }
    }

    private void controlPlane() {
        double newVerticalMotion;
        double damage;
        double newHorizontalMotion;
        double motionDifference;
        double damage2;
        if (!this.isVehicle()) {
            this.setThrustPositive(false);
            this.setThrustNegative(false);
            this.setLeft(false);
            this.setRight(false);
            this.setUp(false);
            this.setDown(false);
            this.setBrake(true);
            this.setStartTime(0);
        }
        Vec3 motionVector = this.getDeltaMovement();
        double verticalMotion = Math.abs(motionVector.y);
        double horizontalMotion = this.getHorizontalMotion(motionVector);
        float engineSpeed = this.getEngineSpeed();
        if (this.isCollidedVertical()) {
            double maxEngineSpeed;
            double speed = this.getDeltaMovement().length();
            if (speed < (maxEngineSpeed = 1.5 * (double)engineSpeed)) {
                speed = Math.min(speed + (double)engineSpeed * 0.005, maxEngineSpeed);
            }
            if (this.isBrake()) {
                speed = EntityPlaneControlBase.decreaseToZero(speed, 1.0 / (speed + 1.0) * 0.012);
            }
            if (engineSpeed <= 0.0f) {
                speed = EntityPlaneControlBase.decreaseToZero(speed, 0.002);
            }
            Vec3 motion = this.getLookAngle().normalize().scale(speed).multiply(1.0, 0.0, 1.0);
            this.setDeltaMovement(motion);
            if (speed > 0.0) {
                this.move(MoverType.SELF, this.getDeltaMovement());
            }
        } else {
            double speed;
            double fallSpeed = this.getFallSpeed();
            Vec3 lookVec = this.getLookAngle();
            float modifiedPitch = (this.getXRot() < 0.0f ? this.getXRot() : Math.min(this.getXRot() * 1.5f, 90.0f)) - 5.0f;
            float pitch = modifiedPitch * ((float)Math.PI / 180);
            double horizontalLook = Math.sqrt(lookVec.x * lookVec.x + lookVec.z * lookVec.z);
            double lookLength = lookVec.length();
            float cosPitch = Mth.cos((float)pitch);
            cosPitch = (float)((double)cosPitch * (double)cosPitch * Math.min(1.0, lookLength / 0.4));
            motionVector = this.getDeltaMovement().add(0.0, fallSpeed * (-1.0 + (double)cosPitch * 0.75), 0.0);
            if (motionVector.y < 0.0 && horizontalLook > 0.0) {
                double down = motionVector.y * -0.1 * (double)cosPitch;
                motionVector = motionVector.add(lookVec.x * down / horizontalLook, down, lookVec.z * down / horizontalLook);
            }
            if (pitch < 0.0f && horizontalLook > 0.0) {
                double d13 = horizontalMotion * (double)(-Mth.sin((float)pitch)) * 0.04;
                motionVector = motionVector.add(-lookVec.x * d13 / horizontalLook, d13 * 3.2, -lookVec.z * d13 / horizontalLook);
            }
            if (horizontalLook > 0.0) {
                motionVector = motionVector.add((lookVec.x / horizontalLook * horizontalMotion - motionVector.x) * 0.1, 0.0, (lookVec.z / horizontalLook * horizontalMotion - motionVector.z) * 0.1);
            }
            if ((speed = (motionVector = motionVector.multiply(0.99, 0.98, 0.99)).length()) < 1.5 * (double)engineSpeed) {
                double addSpeed = 0.0;
                if (speed + (addSpeed += (double)engineSpeed * 0.005 * 4.0) > 1.5 * (double)engineSpeed) {
                    addSpeed = 1.5 * (double)engineSpeed - speed;
                }
                if (addSpeed < 0.0) {
                    addSpeed = 0.0;
                }
                if (this.getPitchPercentage() < -0.25f) {
                    addSpeed = 0.0;
                }
                Vec3 addVec = this.getLookAngle().normalize().scale(addSpeed);
                motionVector = motionVector.add(new Vec3(addVec.x, 0.0, addVec.z));
            }
            if (this.isStalling(motionVector)) {
                motionVector = motionVector.multiply(new Vec3(0.975, 1.025, 0.975));
            }
            this.setDeltaMovement(motionVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
        if (this.level().isClientSide) {
            return;
        }
        if (this.isCollidedHorizontal() && (damage2 = (motionDifference = horizontalMotion - (newHorizontalMotion = this.getHorizontalMotion(this.getDeltaMovement()))) * 1000.0 - 150.0) > 0.0) {
            this.damagePlane(damage2, true);
        }
        if (this.isCollidedVertical() && (damage = (motionDifference = verticalMotion - (newVerticalMotion = Math.abs(this.getDeltaMovement().y))) * 1000.0 - 100.0) > 0.0) {
            this.damagePlane(damage, false);
        }
    }

    protected boolean isStalling(Vec3 motionVector) {
        return motionVector.multiply(1.0, 0.0, 1.0).length() / 4.0 < -motionVector.y;
    }

    public abstract double getFallSpeed();

    @Override
    public void damagePlane(double damage, boolean horizontal) {
        super.damagePlane(damage, horizontal);
        if (horizontal && damage > 5.0 || damage > 20.0) {
            this.setStarted(false);
        }
    }

    public boolean isCollidedVertical() {
        boolean last = this.onGroundLast;
        boolean last2 = this.onGroundLast2;
        this.onGroundLast2 = this.onGroundLast;
        this.onGroundLast = this.onGround();
        return last || last2 || this.onGround();
    }

    public boolean isCollidedHorizontal() {
        return this.horizontalCollision;
    }

    public double getHorizontalMotion(Vec3 vec3d) {
        return Math.sqrt(vec3d.x * vec3d.x + vec3d.z * vec3d.z);
    }

    public double getAngle(Vec3 vec1, Vec3 vec2) {
        return Math.acos(Math.abs(vec1.dot(vec2)) / (vec1.length() * vec2.length()));
    }

    private static double decreaseToZero(double num, double amount) {
        double erg;
        if (num < 0.0) {
            erg = num + amount;
            if (erg > 0.0) {
                erg = 0.0;
            }
        } else {
            erg = num - amount;
            if (erg < 0.0) {
                erg = 0.0;
            }
        }
        return erg;
    }

    public float getPitchPercentage() {
        return this.getXRot() / 90.0f;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STARTED, (Object)false);
        builder.define(START_TIME, (Object)0);
        builder.define(ENGINE_SPEED, (Object)Float.valueOf(0.0f));
        builder.define(THRUST_POSITIVE, (Object)false);
        builder.define(THRUST_NEGATIVE, (Object)false);
        builder.define(LEFT, (Object)false);
        builder.define(RIGHT, (Object)false);
        builder.define(UP, (Object)false);
        builder.define(DOWN, (Object)false);
        builder.define(BRAKE, (Object)false);
    }

    public void updateControls(boolean up, boolean down, boolean thrustPos, boolean thrustNeg, boolean left, boolean right, boolean braking, boolean starting) {
        boolean needsUpdate = false;
        if (this.isThrustPositive() != thrustPos) {
            this.setThrustPositive(thrustPos);
            needsUpdate = true;
        }
        if (this.isThrustNegative() != thrustNeg) {
            this.setThrustNegative(thrustNeg);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.isUp() != up) {
            this.setUp(up);
            needsUpdate = true;
        }
        if (this.isDown() != down) {
            this.setDown(down);
            needsUpdate = true;
        }
        if (this.isBrake() != braking) {
            this.setBrake(braking);
            needsUpdate = true;
        }
        if (starting) {
            if (this.isStarted()) {
                if (this.getStartTime() <= 0) {
                    this.setStarted(false);
                }
            } else {
                this.setStartTime(this.getStartTime() + 1);
            }
            needsUpdate = true;
        } else if (this.getStartTime() > 0) {
            this.setStartTime(0);
            needsUpdate = true;
        }
        if (this.level().isClientSide && needsUpdate) {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageControlPlane(up, down, thrustPos, thrustNeg, left, right, braking, starting), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("EngineSpeed", this.getEngineSpeed());
        compound.putBoolean("Started", this.isStarted());
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setEngineSpeed(compound.getFloat("EngineSpeed"));
        ((EntityPlaneSoundBase)this).setStarted(compound.getBoolean("Started"), false);
    }

    public boolean isStarted() {
        return (Boolean)this.entityData.get(STARTED);
    }

    public void setStarted(boolean started) {
        this.entityData.set(STARTED, (Object)started);
    }

    public boolean isBrake() {
        return (Boolean)this.entityData.get(BRAKE);
    }

    public void setBrake(boolean breaking) {
        this.entityData.set(BRAKE, (Object)breaking);
    }

    public boolean isThrustPositive() {
        return (Boolean)this.entityData.get(THRUST_POSITIVE);
    }

    public void setThrustPositive(boolean thrustPositive) {
        this.entityData.set(THRUST_POSITIVE, (Object)thrustPositive);
    }

    public boolean isThrustNegative() {
        return (Boolean)this.entityData.get(THRUST_NEGATIVE);
    }

    public void setThrustNegative(boolean thrustNegative) {
        this.entityData.set(THRUST_NEGATIVE, (Object)thrustNegative);
    }

    public boolean isLeft() {
        return (Boolean)this.entityData.get(LEFT);
    }

    public void setLeft(boolean left) {
        this.entityData.set(LEFT, (Object)left);
    }

    public boolean isRight() {
        return (Boolean)this.entityData.get(RIGHT);
    }

    public void setRight(boolean right) {
        this.entityData.set(RIGHT, (Object)right);
    }

    public boolean isUp() {
        return (Boolean)this.entityData.get(UP);
    }

    public void setUp(boolean up) {
        this.entityData.set(UP, (Object)up);
    }

    public boolean isDown() {
        return (Boolean)this.entityData.get(DOWN);
    }

    public void setDown(boolean down) {
        this.entityData.set(DOWN, (Object)down);
    }

    public float getEngineSpeed() {
        return ((Float)this.entityData.get(ENGINE_SPEED)).floatValue();
    }

    public void setEngineSpeed(float speed) {
        this.entityData.set(ENGINE_SPEED, (Object)Float.valueOf(speed));
    }

    public int getStartTime() {
        return (Integer)this.entityData.get(START_TIME);
    }

    public void setStartTime(int startTime) {
        this.entityData.set(START_TIME, (Object)startTime);
    }
}

