/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.item;

import de.maxhenkel.plane.entity.EntityBushPlane;
import de.maxhenkel.plane.entity.EntityCargoPlane;
import de.maxhenkel.plane.entity.EntityPlane;
import de.maxhenkel.plane.item.ItemBushPlane;
import de.maxhenkel.plane.item.ItemCargoPlane;
import de.maxhenkel.plane.item.ItemCraftingComponent;
import de.maxhenkel.plane.item.ItemPlane;
import de.maxhenkel.plane.item.ItemWrench;
import de.maxhenkel.plane.item.PlaneData;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItems {
    private static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"plane");
    public static final DeferredHolder<Item, ItemPlane>[] PLANES = Arrays.asList(EntityPlane.Type.values()).stream().map(type -> ITEM_REGISTER.register("plane_" + type.getTypeName(), () -> new ItemPlane((EntityPlane.Type)((Object)type)))).collect(Collectors.toList()).toArray(new DeferredHolder[0]);
    public static final DeferredHolder<Item, ItemCargoPlane>[] CARGO_PLANES = Arrays.asList(EntityCargoPlane.Type.values()).stream().map(type -> ITEM_REGISTER.register("cargo_plane_" + type.getTypeName(), () -> new ItemCargoPlane((EntityCargoPlane.Type)((Object)type)))).collect(Collectors.toList()).toArray(new DeferredHolder[0]);
    public static final DeferredHolder<Item, ItemBushPlane>[] BUSH_PLANES = Arrays.asList(EntityBushPlane.Type.values()).stream().map(type -> ITEM_REGISTER.register("bush_plane_" + type.getTypeName(), () -> new ItemBushPlane((EntityBushPlane.Type)((Object)type)))).collect(Collectors.toList()).toArray(new DeferredHolder[0]);
    public static final DeferredHolder<Item, ItemWrench> WRENCH = ITEM_REGISTER.register("wrench", () -> new ItemWrench());
    public static final DeferredHolder<Item, ItemCraftingComponent> PLANE_WHEEL = ITEM_REGISTER.register("plane_wheel", () -> new ItemCraftingComponent());
    public static final DeferredHolder<Item, ItemCraftingComponent> PLANE_ENGINE = ITEM_REGISTER.register("plane_engine", () -> new ItemCraftingComponent());
    public static final DeferredHolder<Item, ItemCraftingComponent> DIAMOND_REINFORCED_IRON = ITEM_REGISTER.register("diamond_reinforced_iron", () -> new ItemCraftingComponent());
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"plane");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<PlaneData>> PLANE_DATA_COMPONENT = DATA_COMPONENT_TYPE_REGISTER.register("plane_data", () -> DataComponentType.builder().persistent(PlaneData.CODEC).networkSynchronized(PlaneData.STREAM_CODEC).build());

    public static void init(IEventBus eventBus) {
        ITEM_REGISTER.register(eventBus);
        DATA_COMPONENT_TYPE_REGISTER.register(eventBus);
    }
}

