/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.plane.corelib.client.obj.OBJModel;
import de.maxhenkel.plane.corelib.client.obj.OBJModelInstance;
import de.maxhenkel.plane.corelib.client.obj.OBJModelOptions;
import de.maxhenkel.plane.corelib.math.Rotation;
import de.maxhenkel.plane.entity.EntityBushPlane;
import de.maxhenkel.plane.entity.render.AbstractPlaneModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3d;

public class BushPlaneModel
extends AbstractPlaneModel<EntityBushPlane> {
    private static final List<OBJModelInstance<EntityBushPlane>> MODELS = Arrays.asList(new OBJModelInstance<EntityBushPlane>(new OBJModel(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"models/entity/wheel.obj")), new OBJModelOptions<EntityBushPlane>(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"textures/entity/wheel.png"), new Vector3d(-0.625, 0.125, -1.09375), (plane, matrixStack, partialTicks) -> {
        matrixStack.scale(0.0625f, 0.0625f, 0.0625f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-plane.getWheelRotation(partialTicks)));
    })), new OBJModelInstance<EntityBushPlane>(new OBJModel(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"models/entity/wheel.obj")), new OBJModelOptions<EntityBushPlane>(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"textures/entity/wheel.png"), new Vector3d(0.625, 0.125, -1.09375), (plane, matrixStack, partialTicks) -> {
        matrixStack.scale(0.0625f, 0.0625f, 0.0625f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-plane.getWheelRotation(partialTicks)));
    })), new OBJModelInstance<EntityBushPlane>(new OBJModel(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"models/entity/propeller.obj")), new OBJModelOptions<EntityBushPlane>(ResourceLocation.withDefaultNamespace((String)"textures/block/spruce_planks.png"), new Vector3d(0.0, 1.0, -1.84375), (plane, matrixStack, partialTicks) -> {
        matrixStack.scale(0.0625f, 0.0625f, 0.0625f);
        matrixStack.mulPose(Axis.ZP.rotationDegrees(-plane.getPropellerRotation(partialTicks)));
    })));
    private static final List<OBJModelInstance<EntityBushPlane>> OAK_MODEL = BushPlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/oak_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> DARK_OAK_MODEL = BushPlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/dark_oak_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> BIRCH_MODEL = BushPlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/birch_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> JUNGLE_MODEL = BushPlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/jungle_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> ACACIA_MODEL = BushPlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/acacia_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> SPRUCE_MODEL = BushPlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/spruce_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> WARPED_MODEL = BushPlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/warped_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> CRIMSON_MODEL = BushPlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/crimson_planks.png"));

    public BushPlaneModel(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    @Override
    protected void translateName(EntityBushPlane plane, PoseStack matrixStack, boolean left) {
        if (left) {
            matrixStack.translate(0.500625, -1.25, 0.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        } else {
            matrixStack.translate(-0.500625, -1.25, 0.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        }
    }

    @Override
    public List<OBJModelInstance<EntityBushPlane>> getModels(EntityBushPlane entity) {
        return BushPlaneModel.getModelFromType(entity);
    }

    private static List<OBJModelInstance<EntityBushPlane>> getModelFromType(EntityBushPlane plane) {
        switch (plane.getPlaneType()) {
            default: {
                return OAK_MODEL;
            }
            case DARK_OAK: {
                return DARK_OAK_MODEL;
            }
            case SPRUCE: {
                return SPRUCE_MODEL;
            }
            case JUNGLE: {
                return JUNGLE_MODEL;
            }
            case BIRCH: {
                return BIRCH_MODEL;
            }
            case ACACIA: {
                return ACACIA_MODEL;
            }
            case WARPED: {
                return WARPED_MODEL;
            }
            case CRIMSON: 
        }
        return CRIMSON_MODEL;
    }

    private static List<OBJModelInstance<EntityBushPlane>> getPlaneModel(ResourceLocation texture) {
        ArrayList<OBJModelInstance<EntityBushPlane>> models = new ArrayList<OBJModelInstance<EntityBushPlane>>(MODELS);
        models.add(new OBJModelInstance<EntityBushPlane>(new OBJModel(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"models/entity/bush_plane.obj")), new OBJModelOptions<EntityBushPlane>(texture, new Vector3d(0.0, 0.5, 0.0), new Rotation(180.0f, Axis.YP), (plane, matrixStack, partialTicks) -> {})));
        return models;
    }
}

