/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import journeymap.api.services.Services;
import journeymap.common.util.PermissionsManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerData
extends SavedData {
    private static final Codec<Player> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("player_id").forGetter(Player::getUuid), (App)Codec.BOOL.fieldOf("hidden_underground").forGetter(Player::isHiddenUnderground), (App)Codec.BOOL.fieldOf("radar_visible").forGetter(Player::isVisible), (App)Codec.BOOL.fieldOf("view_loaded_chunk_entity").forGetter(Player::isChunkEntity), (App)Codec.BOOL.fieldOf("view_loaded_chunk_full").forGetter(Player::isChunkFull), (App)Codec.BOOL.fieldOf("view_loaded_chunk_block").forGetter(Player::isChunkBlock), (App)Codec.BOOL.fieldOf("view_loaded_chunk_inaccessible").forGetter(Player::isChunkInaccessible)).apply((Applicative)instance, Player::new));
    private static final String DAT_FILE = "JMPlayerSettings";
    private CompoundTag data = new CompoundTag();
    Map<String, Player> playerMap = new HashMap<String, Player>();

    public PlayerData() {
        Services.COMMON_SERVICE.getServer().getLevel(Level.OVERWORLD).getDataStorage().set(DAT_FILE, (SavedData)this);
        this.setDirty();
    }

    public static PlayerData getPlayerData() {
        return PlayerData.get();
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        this.playerMap.forEach((uuid, player) -> {
            DataResult result = CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, player);
            if (result.result().isPresent()) {
                this.data.put(uuid, (Tag)result.result().get());
            }
        });
        compound.put(DAT_FILE, (Tag)this.data);
        return compound;
    }

    private static PlayerData get() {
        ServerLevel level = Services.COMMON_SERVICE.getServer().getLevel(Level.OVERWORLD);
        return (PlayerData)level.getDataStorage().computeIfAbsent(PlayerData.dataFactory(), DAT_FILE);
    }

    private static PlayerData load(CompoundTag nbt, HolderLookup.Provider provider) {
        PlayerData playerData = new PlayerData();
        playerData.data = nbt.getCompound(DAT_FILE);
        return playerData;
    }

    public static SavedData.Factory<PlayerData> dataFactory() {
        return new SavedData.Factory(PlayerData::load, PlayerData::load, DataFixTypes.OPTIONS);
    }

    private static PlayerData load() {
        return new PlayerData();
    }

    public Player getPlayer(ServerPlayer serverPlayer) {
        String uuid = serverPlayer.getStringUUID();
        Player player = this.playerMap.get(uuid);
        if (player == null) {
            CompoundTag playterTag;
            DataResult result;
            if (this.data.contains(uuid) && (result = CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)(playterTag = this.data.getCompound(uuid)))).result().isPresent()) {
                Player playerData = (Player)result.result().get();
                this.playerMap.put(uuid, playerData);
                return playerData;
            }
            player = new Player(uuid);
            DataResult result2 = CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)player);
            this.data.put(uuid, (Tag)result2.result().get());
            this.playerMap.put(uuid, player);
        }
        return player;
    }

    public static class Player {
        private boolean hiddenUnderground;
        private boolean visible;
        private boolean chunkEntity;
        private boolean chunkFull;
        private boolean chunkBlock;
        private boolean chunkInaccessible;
        private final String uuid;

        public Player(String uuid) {
            this(uuid, false, true, false, false, false, false);
        }

        public Player(String uuid, boolean hiddenUnderground, boolean visible, boolean chunkEntity, boolean chunkFull, boolean chunkBlock, boolean chunkInaccessible) {
            this.uuid = uuid;
            this.hiddenUnderground = hiddenUnderground;
            this.visible = visible;
            this.chunkEntity = chunkEntity;
            this.chunkFull = chunkFull;
            this.chunkBlock = chunkBlock;
            this.chunkInaccessible = chunkInaccessible;
        }

        public String getUuid() {
            return this.uuid;
        }

        public boolean isHiddenUnderground() {
            return this.hiddenUnderground;
        }

        public void setHiddenUnderground(boolean hiddenUnderground) {
            this.hiddenUnderground = hiddenUnderground;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isChunkEntity() {
            return this.chunkEntity;
        }

        public void setChunkEntity(boolean chunkEntity) {
            this.chunkEntity = chunkEntity;
        }

        public boolean isChunkFull() {
            return this.chunkFull;
        }

        public void setChunkFull(boolean chunkFull) {
            this.chunkFull = chunkFull;
        }

        public boolean isChunkBlock() {
            return this.chunkBlock;
        }

        public void setChunkBlock(boolean chunkBlock) {
            this.chunkBlock = chunkBlock;
        }

        public boolean isChunkInaccessible() {
            return this.chunkInaccessible;
        }

        public void setChunkInaccessible(boolean chunkInaccessible) {
            this.chunkInaccessible = chunkInaccessible;
        }

        public boolean viewChunkEntity() {
            ServerPlayer player = Services.COMMON_SERVICE.getServer().getPlayerList().getPlayer(UUID.fromString(this.uuid));
            return this.chunkEntity && PermissionsManager.getInstance().canServerAdmin(player);
        }

        public boolean viewChunkFull() {
            ServerPlayer player = Services.COMMON_SERVICE.getServer().getPlayerList().getPlayer(UUID.fromString(this.uuid));
            return this.chunkFull && PermissionsManager.getInstance().canServerAdmin(player);
        }

        public boolean viewChunkBlock() {
            ServerPlayer player = Services.COMMON_SERVICE.getServer().getPlayerList().getPlayer(UUID.fromString(this.uuid));
            return this.chunkBlock && PermissionsManager.getInstance().canServerAdmin(player);
        }

        public boolean viewChunkInaccessible() {
            ServerPlayer player = Services.COMMON_SERVICE.getServer().getPlayerList().getPlayer(UUID.fromString(this.uuid));
            return this.chunkInaccessible && PermissionsManager.getInstance().canServerAdmin(player);
        }
    }
}

