/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.common.Journeymap;
import journeymap.common.config.AdminConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeoForgeConfig
implements AdminConfig {
    public static final Server SERVER;
    public static final ModConfigSpec SERVER_SPEC;
    public static ModConfigSpec.ConfigValue<List<? extends String>> serverAdmins;
    public static ModConfigSpec.ConfigValue<Boolean> opAccess;

    @Override
    public boolean getOpAccess() {
        return (Boolean)opAccess.get();
    }

    @Override
    public List<String> getAdmins() {
        return new ArrayList<String>((Collection)serverAdmins.get());
    }

    @Override
    public void load() {
        Journeymap.getLogger().info("Loading JourneyMap Forge Configs");
        if (serverAdmins == null) {
            if (((List)NeoForgeConfig.SERVER.serverAdmins.get()).contains("12341234132")) {
                ((List)NeoForgeConfig.SERVER.serverAdmins.get()).remove("12341234132");
                NeoForgeConfig.SERVER.serverAdmins.save();
            }
            serverAdmins = NeoForgeConfig.SERVER.serverAdmins;
        }
        if (opAccess == null) {
            opAccess = NeoForgeConfig.SERVER.opAccess;
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ModConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ModConfigSpec.ConfigValue<List<? extends String>> serverAdmins;
        public final ModConfigSpec.ConfigValue<Boolean> opAccess;

        Server(ModConfigSpec.Builder builder) {
            builder.push("admins");
            this.opAccess = builder.comment(new String[]{"Default, all Ops have access to Server Admin UI in the Options screen.", "If set to false, only users in the Admin List will have access.", "If set to true, all ops and users in the Admin List will have access."}).define("opAccess", true);
            this.serverAdmins = builder.comment(new String[]{"Players in this list have access to the Journeymap's Server Admin Panel", "Add users by name or UUID, Prefer UUID as it is more secure!", "Each value on a new line with the example format provided. (please delete the default values)"}).defineList("serverAdmins", (List)Lists.newArrayList((Object[])new String[]{"mysticdrew", "79f597fe-2877-4ecb-acdf-8c58cc1854ca"}), e -> e instanceof String);
            builder.pop();
        }
    }
}

