/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.io.FileHandler;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;

public class ExternalWaypointFinder {
    private final List<ClientWaypointImpl> xaeroWaypoints = new ArrayList<ClientWaypointImpl>();
    private boolean didSearch = false;

    public boolean hasExternalWaypoints() {
        if (!this.didSearch) {
            try {
                this.findXaeroWaypointsForWorld();
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error finding external waypoints.", (Throwable)e);
            }
        }
        return !this.getXaeroWaypoints().isEmpty();
    }

    public List<ClientWaypointImpl> getXaeroWaypoints() {
        return this.xaeroWaypoints.stream().filter(waypoint -> !this.waypointExist((Waypoint)waypoint)).toList();
    }

    private boolean waypointExist(Waypoint waypoint) {
        for (ClientWaypointImpl wp : WaypointStore.getInstance().getAll()) {
            if (wp.getX() != waypoint.getX() || wp.getZ() != waypoint.getZ() || wp.getY() != waypoint.getY() || !wp.getGroupId().equalsIgnoreCase(waypoint.getGroupId()) || !wp.getPrimaryDimension().equalsIgnoreCase(waypoint.getPrimaryDimension())) continue;
            return true;
        }
        return false;
    }

    private void findXaeroWaypointsForWorld() {
        this.didSearch = true;
        Minecraft mc = Minecraft.getInstance();
        Object worldDirectory = mc.isSingleplayer() || Minecraft.getInstance().getCurrentServer() == null || Minecraft.getInstance().getCurrentServer().isLan() ? mc.getSingleplayerServer().storageSource.getLevelId() : "Multiplayer_" + Minecraft.getInstance().getCurrentServer().ip;
        File xaeroMiniMapDir = new File(FileHandler.getMinecraftDirectory(), "xaero/minimap/" + (String)worldDirectory);
        if (xaeroMiniMapDir.exists()) {
            File[] directories;
            for (File wpDir : directories = xaeroMiniMapDir.listFiles(File::isDirectory)) {
                if (!wpDir.isDirectory()) continue;
                File waypointFile = new File(wpDir, "waypoints.txt");
                String dim = this.getDimensionFromDirectoryName(wpDir.getName());
                this.xaeroWaypoints.addAll(this.buildWaypoints(dim, waypointFile));
            }
        }
    }

    private List<ClientWaypointImpl> buildWaypoints(String dimension, File waypoints) {
        ArrayList<ClientWaypointImpl> xaeroWaypoints = new ArrayList<ClientWaypointImpl>();
        try {
            return Files.readAllLines(waypoints.toPath()).stream().skip(3L).map(wp -> this.parsed((String)wp, dimension)).filter(waypoint -> !this.waypointExist((Waypoint)waypoint)).toList();
        }
        catch (IOException e) {
            System.out.println(e);
            return xaeroWaypoints;
        }
    }

    private ClientWaypointImpl parsed(String wp, String dimension) {
        String[] parsed = wp.split(":");
        String name = parsed[1].replace("gui.xaero_", "");
        int x = Integer.parseInt(parsed[3]);
        int y = Integer.parseInt(parsed[4].replace("~", "63"));
        int z = Integer.parseInt(parsed[5]);
        BlockPos pos = new BlockPos(x, y, z);
        if (name.equalsIgnoreCase("deathpoint")) {
            return (ClientWaypointImpl)WaypointFactoryImpl.createWaypoint("journeymap", pos, name, dimension, true, true);
        }
        return (ClientWaypointImpl)WaypointFactoryImpl.createWaypoint("journeymap", pos, name, dimension, false, true);
    }

    private String getDimensionFromDirectoryName(String name) {
        String value;
        return switch (value = name.split("%")[1]) {
            case "-1" -> "minecraft:the_nether";
            case "1" -> "minecraft:the_end";
            case "0" -> "minecraft:overworld";
            default -> value.replace("$", ":");
        };
    }
}

