/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import journeymap.api.v2.client.display.ImageOverlay;
import journeymap.api.v2.client.model.MapImage;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class DrawImageStep
extends BaseOverlayDrawStep<ImageOverlay> {
    private Point2D.Double northWestPosition;
    private Point2D.Double southEastPosition;
    private DynamicTexture iconTexture;
    private boolean hasError;

    public DrawImageStep(ImageOverlay marker) {
        super(marker);
    }

    @Override
    public void draw(GuiGraphics graphics, MultiBufferSource buffers, DrawStep.Pass pass, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        if (!this.isOnScreen(xOffset, yOffset, renderer, rotation)) {
            return;
        }
        if (pass == DrawStep.Pass.Object) {
            this.ensureTexture();
            if (!this.hasError && this.iconTexture != null) {
                MapImage icon = ((ImageOverlay)this.overlay).getImage();
                double width = this.screenBounds.width;
                double height = this.screenBounds.height;
                RenderType renderType = ((ImageOverlay)this.getOverlay()).getImage().isBlur() ? JMRenderTypes.getIconNoBlur((AbstractTexture)this.iconTexture) : JMRenderTypes.getIcon((AbstractTexture)this.iconTexture);
                VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
                DrawUtil.drawQuad(graphics.pose(), vertexBuilder, icon.getColor(), icon.getOpacity(), this.northWestPosition.x + xOffset, this.northWestPosition.y + yOffset, width, height, 0.0, 0.0, icon.getDisplayWidth() / (double)((TextureAccess)this.iconTexture).journeymap$getWidth(), icon.getDisplayHeight() / (double)((TextureAccess)this.iconTexture).journeymap$getHeight(), icon.getRotation(), false);
            }
        } else if (pass == DrawStep.Pass.Text) {
            super.drawText(graphics, pass, xOffset, yOffset, renderer, fontScale, rotation);
        }
    }

    protected void ensureTexture() {
        if (this.iconTexture != null) {
            return;
        }
        try {
            MapImage image = ((ImageOverlay)this.overlay).getImage();
            ResourceLocation resourceLocation = image.getImageLocation();
            ResourceLocation fake = ResourceLocation.fromNamespaceAndPath((String)"fake", (String)CommonConstants.getSafeString(((ImageOverlay)this.overlay).getGuid(), "-").toLowerCase(Locale.ROOT));
            if (resourceLocation == null) {
                DynamicTexture texture = new DynamicTexture(image.getImage());
                Minecraft.getInstance().getTextureManager().register(fake, (AbstractTexture)texture);
                this.iconTexture = TextureCache.getTexture(fake);
            } else {
                this.iconTexture = TextureCache.getTexture(resourceLocation);
            }
            this.iconTexture.bind();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting ImageOverlay marimage upperTexture: " + String.valueOf(e), (Throwable)e);
            this.hasError = true;
        }
    }

    @Override
    protected void updatePositions(Renderer renderer, double rotation) {
        this.northWestPosition = renderer.getBlockPixelInGrid(((ImageOverlay)this.overlay).getNorthWestPoint());
        this.southEastPosition = renderer.getBlockPixelInGrid(((ImageOverlay)this.overlay).getSouthEastPoint());
        this.screenBounds = new Rectangle2D.Double(this.northWestPosition.x, this.northWestPosition.y, 0.0, 0.0);
        this.screenBounds.add(this.southEastPosition);
        TextProperties textProperties = ((ImageOverlay)this.overlay).getTextProperties();
        this.labelPosition.setLocation(this.screenBounds.getCenterX() + (double)textProperties.getOffsetX(), this.screenBounds.getCenterY() + (double)textProperties.getOffsetY());
    }

    public static class SimpleCacheLoader
    extends CacheLoader<ImageOverlay, DrawImageStep> {
        public DrawImageStep load(ImageOverlay overlay) throws Exception {
            return new DrawImageStep(overlay);
        }
    }
}

