/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.base.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import journeymap.client.data.DataCache;
import journeymap.common.Journeymap;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.log.LogFormatter;
import journeymap.common.mixin.client.BiomeInvoker;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BiomeMD
implements Comparable<BiomeMD> {
    public static final BiomeMD THE_VOID = new BiomeMD(BiomeMD.createTheVoidBiome());
    private static final Logger LOGGER = Journeymap.getLogger();
    private final Biome biome;
    private int grassColor;
    private int fogColor;
    private int foliageColor;
    private int waterColor;

    private static Biome createTheVoidBiome() {
        BiomeSpecialEffects specialEffects = new BiomeSpecialEffects.Builder().fogColor(0).waterColor(0).waterFogColor(0).skyColor(0).build();
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(specialEffects).mobSpawnSettings(MobSpawnSettings.EMPTY).generationSettings(BiomeGenerationSettings.EMPTY).temperatureAdjustment(Biome.TemperatureModifier.NONE).build();
    }

    public BiomeMD(@NotNull Biome biome) {
        this.biome = biome;
        this.grassColor = biome.getSpecialEffects().getGrassColorOverride().orElseGet(() -> ((BiomeInvoker)biome).invokeGetGrassColorFromTexture());
        this.fogColor = biome.getFogColor();
        this.foliageColor = biome.getFoliageColor();
        this.waterColor = biome.getWaterColor();
    }

    public static Set<BiomeMD> getAll(Level level) {
        return level.registryAccess().registryOrThrow(Registries.BIOME).stream().map(BiomeMD::get).collect(Collectors.toSet());
    }

    public static BiomeMD get(Level level, ResourceLocation id) {
        if (level == null) {
            LOGGER.warn("Level cannot be null when getting BiomeMD from a resource location");
            return THE_VOID;
        }
        Biome biome = (Biome)level.registryAccess().registryOrThrow(Registries.BIOME).get(id);
        return DataCache.INSTANCE.getBiomeMD(biome);
    }

    public static BiomeMD get(Biome biome) {
        return DataCache.INSTANCE.getBiomeMD(biome);
    }

    public String getBiomeId() {
        return BiomeHelper.getBiomeResource(this.biome).toString();
    }

    public int getGrassColor(double posX, double posZ) {
        return this.biome.getSpecialEffects().getGrassColorModifier().modifyColor(posX, posZ, this.grassColor);
    }

    public int getGrassColor() {
        return this.grassColor;
    }

    public int getFogColor() {
        return this.fogColor;
    }

    public int getFoliageColor() {
        return this.foliageColor;
    }

    public int getWaterColor() {
        return this.waterColor;
    }

    public void setGrassColor(int color) {
        this.grassColor = color;
    }

    public void setFogColor(int color) {
        this.fogColor = color;
    }

    public void setFoliageColor(int color) {
        this.foliageColor = color;
    }

    public void setWaterColor(int color) {
        this.waterColor = color;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BiomeMD)) {
            return false;
        }
        BiomeMD biomeMD = (BiomeMD)o;
        return this.biome.equals(biomeMD.biome);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.biome});
    }

    public String toString() {
        return String.format("BiomeMD [%s]", BiomeHelper.getBiomeResource(this.biome));
    }

    @Override
    public int compareTo(BiomeMD that) {
        return BiomeHelper.getBiomeResource(this.biome).compareTo(BiomeHelper.getBiomeResource(that.biome));
    }

    public static class CacheLoader
    extends com.google.common.cache.CacheLoader<Biome, BiomeMD> {
        public BiomeMD load(@NotNull Biome biome) throws Exception {
            try {
                if (biome == null) {
                    LOGGER.warn("Null biome will be treated like the void: {}", (Object)biome);
                    return THE_VOID;
                }
                return new BiomeMD(biome);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Can't get BiomeMD for %s : %s", BiomeHelper.getBiomeResource(biome), LogFormatter.toPartialString(e)));
                return THE_VOID;
            }
        }
    }
}

