/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.RegionTileShaders;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;

public class ShaderRegistrationHandler {
    public static Map<ResourceLocation, ShaderRegistration> getShaders() {
        HashMap<ResourceLocation, ShaderRegistration> shaderMap = new HashMap<ResourceLocation, ShaderRegistration>();
        RegionTileShaders.REGION_SHADERS.forEach(name -> {
            if (!"default".equals(name)) {
                ResourceLocation location = ShaderRegistrationHandler.getCoreLocation(name);
                ShaderRegistration registration = new ShaderRegistration(DefaultVertexFormat.POSITION_TEX_COLOR, shaderInstance -> JMRenderTypes.registerMapShader(name, shaderInstance));
                shaderMap.put(location, registration);
            }
        });
        ResourceLocation location = ShaderRegistrationHandler.getCoreLocation("jm_position_tex_color");
        ShaderRegistration registration = new ShaderRegistration(DefaultVertexFormat.POSITION_TEX_COLOR, JMRenderTypes::registerPosTexColorShader);
        shaderMap.put(location, registration);
        return shaderMap;
    }

    static ResourceLocation getCoreLocation(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)name);
    }

    public record ShaderRegistration(VertexFormat format, Consumer<ShaderInstance> onLoad) {
    }
}

