/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.client.rendering;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.client.rendering.BalmRenderers;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public class NeoForgeBalmRenderers
implements BalmRenderers {
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();

    @Override
    public ModelLayerLocation registerModel(ResourceLocation location, Supplier<LayerDefinition> layerDefinition) {
        ModelLayerLocation modelLayerLocation = new ModelLayerLocation(location, "main");
        this.getActiveRegistrations().layerDefinitions.put(modelLayerLocation, layerDefinition);
        return modelLayerLocation;
    }

    @Override
    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> type, EntityRendererProvider<? super T> provider) {
        this.getActiveRegistrations().entityRenderers.add(Pair.of(type::get, provider));
    }

    @Override
    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> type, BlockEntityRendererProvider<? super T> provider) {
        this.getActiveRegistrations().blockEntityRenderers.add(Pair.of(type::get, provider));
    }

    @Override
    public void registerBlockColorHandler(BlockColor color, Supplier<Block[]> blocks) {
        this.getActiveRegistrations().blockColors.add(new ColorRegistration(color, blocks));
    }

    @Override
    public void registerItemColorHandler(ItemColor color, Supplier<ItemLike[]> items) {
        this.getActiveRegistrations().itemColors.add(new ColorRegistration(color, items));
    }

    @Override
    public void setBlockRenderType(Supplier<Block> block, RenderType renderType) {
    }

    public void register(String modId, IEventBus eventBus) {
        eventBus.register((Object)this.getRegistrations(modId));
    }

    private Registrations getActiveRegistrations() {
        return this.getRegistrations(ModLoadingContext.get().getActiveNamespace());
    }

    private Registrations getRegistrations(String modId) {
        return this.registrations.computeIfAbsent(modId, it -> new Registrations());
    }

    private static class Registrations {
        public final Map<ModelLayerLocation, Supplier<LayerDefinition>> layerDefinitions = new HashMap<ModelLayerLocation, Supplier<LayerDefinition>>();
        public final List<Pair<Supplier<BlockEntityType<?>>, BlockEntityRendererProvider<BlockEntity>>> blockEntityRenderers = new ArrayList();
        public final List<Pair<Supplier<EntityType<?>>, EntityRendererProvider<Entity>>> entityRenderers = new ArrayList();
        public final List<ColorRegistration<BlockColor, Block>> blockColors = new ArrayList<ColorRegistration<BlockColor, Block>>();
        public final List<ColorRegistration<ItemColor, ItemLike>> itemColors = new ArrayList<ColorRegistration<ItemColor, ItemLike>>();

        private Registrations() {
        }

        @SubscribeEvent
        public void setupClient(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public void initRenderers(EntityRenderersEvent.RegisterRenderers event) {
            for (Pair<Supplier<BlockEntityType<?>>, BlockEntityRendererProvider<BlockEntity>> pair : this.blockEntityRenderers) {
                event.registerBlockEntityRenderer((BlockEntityType)((Supplier)pair.getFirst()).get(), (BlockEntityRendererProvider)pair.getSecond());
            }
            for (Pair<Supplier<BlockEntityType<?>>, BlockEntityRendererProvider<BlockEntity>> pair : this.entityRenderers) {
                event.registerEntityRenderer((EntityType)((Supplier)pair.getFirst()).get(), (EntityRendererProvider)pair.getSecond());
            }
        }

        @SubscribeEvent
        public void initLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            for (Map.Entry<ModelLayerLocation, Supplier<LayerDefinition>> entry : this.layerDefinitions.entrySet()) {
                event.registerLayerDefinition(entry.getKey(), entry.getValue());
            }
        }

        @SubscribeEvent
        public void initBlockColors(RegisterColorHandlersEvent.Block event) {
            for (ColorRegistration<BlockColor, Block> blockColor : this.blockColors) {
                event.register(blockColor.getColor(), blockColor.getObjects().get());
            }
        }

        @SubscribeEvent
        public void initItemColors(RegisterColorHandlersEvent.Item event) {
            for (ColorRegistration<ItemColor, ItemLike> itemColor : this.itemColors) {
                event.register(itemColor.getColor(), itemColor.getObjects().get());
            }
        }
    }

    private static class ColorRegistration<THandler, TObject> {
        private final THandler color;
        private final Supplier<TObject[]> objects;

        public ColorRegistration(THandler color, Supplier<TObject[]> objects) {
            this.color = color;
            this.objects = objects;
        }

        public THandler getColor() {
            return this.color;
        }

        public Supplier<TObject[]> getObjects() {
            return this.objects;
        }
    }
}

