/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneManager;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.event.WaystoneInitializedEvent;
import net.blay09.mods.waystones.api.event.WaystoneRemovedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdatedEvent;
import net.blay09.mods.waystones.api.event.WaystonesLoadedEvent;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class WaystoneManagerImpl
extends SavedData
implements WaystoneManager {
    private static final String DATA_NAME = "waystones";
    private static final String TAG_WAYSTONES = "Waystones";
    private static final WaystoneManagerImpl clientStorageCopy = new WaystoneManagerImpl();
    private final Map<UUID, Waystone> waystones = new HashMap<UUID, Waystone>();

    public void addWaystone(Waystone waystone) {
        this.waystones.put(waystone.getWaystoneUid(), waystone);
        this.setDirty();
        Balm.getEvents().fireEvent((Object)new WaystoneInitializedEvent(waystone));
    }

    public void updateWaystone(Waystone waystone) {
        WaystoneImpl mutableWaystone = (WaystoneImpl)this.waystones.getOrDefault(waystone.getWaystoneUid(), waystone);
        mutableWaystone.setName(waystone.getName());
        mutableWaystone.setVisibility(waystone.getVisibility());
        this.waystones.put(waystone.getWaystoneUid(), mutableWaystone);
        this.setDirty();
        Balm.getEvents().fireEvent((Object)new WaystoneUpdatedEvent(waystone));
    }

    public void removeWaystone(Waystone waystone) {
        this.waystones.remove(waystone.getWaystoneUid());
        this.setDirty();
        Balm.getEvents().fireEvent((Object)new WaystoneRemovedEvent(waystone));
    }

    @Override
    public Optional<Waystone> getWaystoneAt(BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            return Optional.of(((WaystoneBlockEntityBase)blockEntity).getWaystone());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Waystone> getWaystoneById(UUID waystoneUid) {
        return Optional.ofNullable(this.waystones.get(waystoneUid));
    }

    @Override
    public Optional<Waystone> findWaystoneByName(String name) {
        return this.waystones.values().stream().filter(it -> it.getName().equals((Object)name)).findFirst();
    }

    @Override
    public Stream<Waystone> getWaystones() {
        return this.waystones.values().stream();
    }

    @Override
    public Stream<Waystone> getWaystonesByType(ResourceLocation type) {
        return this.waystones.values().stream().filter(it -> it.getWaystoneType().equals((Object)type));
    }

    @Override
    public List<Waystone> getGlobalWaystones() {
        return this.waystones.values().stream().filter(it -> it.getVisibility() == WaystoneVisibility.GLOBAL).collect(Collectors.toList());
    }

    public static WaystoneManagerImpl read(CompoundTag tagCompound, HolderLookup.Provider provider) {
        WaystoneManagerImpl waystoneManager = new WaystoneManagerImpl();
        ListTag tagList = tagCompound.getList(TAG_WAYSTONES, 10);
        for (Tag tag : tagList) {
            CompoundTag compound = (CompoundTag)tag;
            Waystone waystone = WaystoneImpl.read(compound, provider);
            waystoneManager.waystones.put(waystone.getWaystoneUid(), waystone);
        }
        Balm.getEvents().fireEvent((Object)new WaystonesLoadedEvent(waystoneManager));
        return waystoneManager;
    }

    public CompoundTag save(CompoundTag tagCompound, HolderLookup.Provider provider) {
        ListTag tagList = new ListTag();
        for (Waystone waystone : this.waystones.values()) {
            tagList.add((Object)WaystoneImpl.write(waystone, new CompoundTag(), provider));
        }
        tagCompound.put(TAG_WAYSTONES, (Tag)tagList);
        return tagCompound;
    }

    public static WaystoneManagerImpl get(@Nullable MinecraftServer server) {
        if (server != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            return (WaystoneManagerImpl)Objects.requireNonNull(overworld).getDataStorage().computeIfAbsent(new SavedData.Factory(WaystoneManagerImpl::new, WaystoneManagerImpl::read, DataFixTypes.SAVED_DATA_MAP_DATA), DATA_NAME);
        }
        return clientStorageCopy;
    }
}

