/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.api.error;

import net.blay09.mods.waystones.api.Waystone;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class WaystoneTeleportError {
    private final Component component;

    public WaystoneTeleportError() {
        this.component = Component.empty();
    }

    public WaystoneTeleportError(Component component) {
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public static class NotEnoughXp
    extends WaystoneTeleportError {
        public NotEnoughXp() {
            super((Component)Component.translatable((String)"chat.waystones.not_enough_xp"));
        }
    }

    public static class LeashedDimensionalWarpDenied
    extends WaystoneTeleportError {
        public LeashedDimensionalWarpDenied() {
            super((Component)Component.translatable((String)"chat.waystones.cannot_transport_leashed_dimensional"));
        }
    }

    public static class SpecificLeashedWarpDenied
    extends WaystoneTeleportError {
        private final Entity entity;

        public SpecificLeashedWarpDenied(Entity entity) {
            super((Component)Component.translatable((String)"chat.waystones.cannot_transport_this_leashed"));
            this.entity = entity;
        }

        public Entity getEntity() {
            return this.entity;
        }
    }

    public static class LeashedWarpDenied
    extends WaystoneTeleportError {
        public LeashedWarpDenied() {
            super((Component)Component.translatable((String)"chat.waystones.cannot_transport_leashed"));
        }
    }

    public static class DimensionalWarpDenied
    extends WaystoneTeleportError {
        public DimensionalWarpDenied() {
            super((Component)Component.translatable((String)"chat.waystones.cannot_dimension_warp"));
        }
    }

    public static class CancelledByEvent
    extends WaystoneTeleportError {
    }

    public static class MissingWaystone
    extends WaystoneTeleportError {
        private final Waystone waystone;

        public MissingWaystone(Waystone waystone) {
            super((Component)Component.translatable((String)"chat.waystones.waystone_missing"));
            this.waystone = waystone;
        }

        public Waystone getWaystone() {
            return this.waystone;
        }
    }

    public static class InvalidWaystone
    extends WaystoneTeleportError {
        private final Waystone waystone;

        public InvalidWaystone(Waystone waystone) {
            this.waystone = waystone;
        }

        public Waystone getWaystone() {
            return this.waystone;
        }
    }

    public static class InvalidDimension
    extends WaystoneTeleportError {
        private final ResourceKey<Level> dimension;

        public InvalidDimension(ResourceKey<Level> dimension) {
            this.dimension = dimension;
        }

        public ResourceKey<Level> getDimension() {
            return this.dimension;
        }
    }

    public static class NotOnServer
    extends WaystoneTeleportError {
    }
}

