/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MonolithFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.getBlockState(pos).getBlock() == BOPBlocks.UNMAPPED_END_STONE;
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)pos) || world.getBlockState(pos).is(BlockTags.REPLACEABLE_BY_TREES) || world.getBlockState(pos).getBlock() instanceof BushBlock || world.getBlockState(pos).getBlock() == BOPBlocks.NULL_END_STONE;

    public MonolithFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos startPos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        while (startPos.getY() >= world.getMinBuildHeight() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.below();
        }
        if (!this.placeOn.matches(world, startPos.offset(0, 0, 0))) {
            return false;
        }
        int sizeX = 1 + rand.nextInt(3);
        int sizeZ = 1 + rand.nextInt(3);
        int height = 5 + rand.nextInt(7);
        if (!this.checkSpace(world, startPos.above(), sizeX, sizeZ, height)) {
            return false;
        }
        BlockPos pos = startPos.above();
        for (int x = 0; x <= sizeX; ++x) {
            for (int y = -6; y <= height; ++y) {
                for (int z = 0; z <= sizeZ; ++z) {
                    if (y == height - 1) {
                        if (x != 0 && x != sizeX || z != 0 && z != sizeZ) continue;
                        this.setBlock(world, pos.offset(x, y, z), Blocks.OBSIDIAN.defaultBlockState());
                        continue;
                    }
                    this.setBlock(world, pos.offset(x, y, z), Blocks.OBSIDIAN.defaultBlockState());
                }
            }
        }
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.setBlock((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos, int sizeX, int sizeZ, int height) {
        for (int y = 0; y <= height; ++y) {
            for (int x = 0; x <= sizeX; ++x) {
                for (int z = 0; z <= sizeZ; ++z) {
                    BlockPos pos1 = pos.offset(x, y, z);
                    if (pos1.getY() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

