/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.mail;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.Constants;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.mail.Mailbox;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageUpdateMailboxes;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class DeliveryService
extends SavedData {
    private static final String STORAGE_ID = "refurbished_furniture_delivery_service";
    private final MinecraftServer server;
    private final Map<Pair<ResourceLocation, BlockPos>, Mailbox> locator = new HashMap<Pair<ResourceLocation, BlockPos>, Mailbox>();
    private final Map<UUID, Mailbox> mailboxes = new ConcurrentHashMap<UUID, Mailbox>();
    private final Queue<Mailbox> removal = new ArrayDeque<Mailbox>();
    private final Map<UUID, Pair<ResourceLocation, BlockPos>> pendingNames = new HashMap<UUID, Pair<ResourceLocation, BlockPos>>();
    private final Set<UUID> playerRequests = new HashSet<UUID>();

    public static Optional<DeliveryService> get(MinecraftServer server) {
        ServerLevel level = server.getLevel(Level.OVERWORLD);
        if (level != null) {
            return Optional.of((DeliveryService)level.getDataStorage().computeIfAbsent(DeliveryService.createFactory(server), STORAGE_ID));
        }
        return Optional.empty();
    }

    public static SavedData.Factory<DeliveryService> createFactory(MinecraftServer server) {
        return new SavedData.Factory(() -> new DeliveryService(server), (tag, provider) -> new DeliveryService(server, (CompoundTag)tag, (HolderLookup.Provider)provider), DataFixTypes.SAVED_DATA_FORCED_CHUNKS);
    }

    public DeliveryService(MinecraftServer server) {
        this.server = server;
    }

    public DeliveryService(MinecraftServer server, CompoundTag compound, HolderLookup.Provider provider) {
        this.server = server;
        this.load(compound, provider);
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public void serverTick() {
        while (!this.removal.isEmpty()) {
            Mailbox mailbox2 = this.removal.poll();
            mailbox2.spawnQueueIntoLevel();
            this.mailboxes.remove(mailbox2.id());
            this.locator.remove(Pair.of((Object)mailbox2.levelKey().location(), (Object)mailbox2.pos()));
            this.setDirty();
        }
        this.mailboxes.forEach((uuid, mailbox) -> mailbox.tick());
    }

    public void playerLoggedOut(Player player) {
        this.playerRequests.remove(player.getUUID());
    }

    public boolean sendMail(UUID id, ItemStack stack) {
        Mailbox mailbox = this.mailboxes.get(id);
        if (mailbox != null && mailbox.queue().size() < (Integer)Config.SERVER.mailing.deliveryQueueSize.get()) {
            mailbox.queue().offer(stack);
            this.setDirty();
            return true;
        }
        return false;
    }

    void removeMailbox(Mailbox mailbox) {
        this.removal.offer(mailbox);
    }

    public boolean canCreateMailbox(Player player) {
        long count = this.mailboxes.values().stream().filter(box -> player.getUUID().equals(box.owner().getValue())).count();
        return (long)((Integer)Config.SERVER.mailing.maxMailboxesPerPlayer.get()).intValue() > count;
    }

    public Mailbox getOrCreateMailBox(MailboxBlockEntity blockEntity) {
        this.duplicateIdCheck(blockEntity);
        return this.mailboxes.computeIfAbsent(blockEntity.getId(), uuid -> {
            ResourceKey levelKey = blockEntity.getLevel().dimension();
            BlockPos pos = blockEntity.getBlockPos();
            Mailbox mailbox = new Mailbox((UUID)uuid, (ResourceKey<Level>)levelKey, pos, (MutableObject<UUID>)new MutableObject(), (MutableObject<String>)new MutableObject((Object)""), (Queue<ItemStack>)new ArrayDeque<ItemStack>(), new MutableBoolean(), this);
            this.locator.put((Pair<ResourceLocation, BlockPos>)Pair.of((Object)levelKey.location(), (Object)pos), mailbox);
            this.setDirty();
            return mailbox;
        });
    }

    private void duplicateIdCheck(MailboxBlockEntity blockEntity) {
        Mailbox box = this.mailboxes.get(blockEntity.getId());
        if (box != null && !box.pos().equals((Object)blockEntity.getBlockPos())) {
            blockEntity.regenerateId();
        }
    }

    public Optional<Mailbox> getMailboxAtPosition(Level level, BlockPos pos) {
        return Optional.ofNullable(this.locator.get(Pair.of((Object)level.dimension().location(), (Object)pos)));
    }

    public void markMailboxAsPendingName(Player player, Level level, BlockPos pos) {
        this.pendingNames.put(player.getUUID(), (Pair<ResourceLocation, BlockPos>)Pair.of((Object)level.dimension().location(), (Object)pos));
    }

    public boolean renameMailbox(Player player, Level level, BlockPos pos, String customName) {
        Pair<ResourceLocation, BlockPos> pendingLocation = this.pendingNames.remove(player.getUUID());
        return this.getMailboxAtPosition(level, pos).map(mailbox -> {
            if (!Objects.equals(mailbox.owner().getValue(), player.getUUID())) {
                return false;
            }
            Pair location = Pair.of((Object)level.dimension().location(), (Object)pos);
            return Objects.equals(location, pendingLocation) && mailbox.rename(customName);
        }).orElse(false);
    }

    public void sendMailboxesToPlayer(ServerPlayer player) {
        if (!this.playerRequests.contains(player.getUUID())) {
            Network.getPlay().sendToPlayer(() -> player, (Object)new MessageUpdateMailboxes(this.mailboxes.values()));
            this.playerRequests.add(player.getUUID());
        }
    }

    public void setDirty() {
        super.setDirty();
        this.playerRequests.clear();
    }

    private void load(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains("Mailboxes", 9)) {
            ListTag list = compound.getList("Mailboxes", 10);
            list.forEach(tag -> {
                try {
                    CompoundTag mailboxTag = (CompoundTag)tag;
                    ResourceKey<Level> levelKey = DeliveryService.createLevelKey(mailboxTag.getString("Level"));
                    if (levelKey == null) {
                        Constants.LOG.error("Failed to load a mailbox due to invalid dimension");
                        return;
                    }
                    UUID id = mailboxTag.getUUID("UUID");
                    BlockPos pos = BlockPos.of((long)mailboxTag.getLong("BlockPosition"));
                    MutableObject owner = new MutableObject();
                    if (mailboxTag.contains("Owner", 11)) {
                        owner.setValue((Object)mailboxTag.getUUID("Owner"));
                    }
                    String customName = mailboxTag.getString("CustomName");
                    customName = customName.substring(0, Math.min(customName.length(), 32));
                    Queue<ItemStack> queue = Mailbox.readQueueListTag(mailboxTag, provider);
                    Mailbox mailbox = new Mailbox(id, levelKey, pos, (MutableObject<UUID>)owner, (MutableObject<String>)new MutableObject((Object)customName), queue, new MutableBoolean(), this);
                    this.mailboxes.putIfAbsent(id, mailbox);
                    this.locator.put((Pair<ResourceLocation, BlockPos>)Pair.of((Object)levelKey.location(), (Object)pos), mailbox);
                }
                catch (Exception e) {
                    Constants.LOG.error("Failed to load a mailbox due to invalid data");
                }
            });
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        this.mailboxes.forEach((uuid, mailbox) -> {
            if (!mailbox.removed().booleanValue()) {
                CompoundTag mailboxTag = new CompoundTag();
                mailboxTag.putUUID("UUID", uuid);
                mailboxTag.putString("Level", mailbox.levelKey().location().toString());
                mailboxTag.putLong("BlockPosition", mailbox.pos().asLong());
                Optional.ofNullable((UUID)mailbox.owner().getValue()).ifPresent(id -> mailboxTag.putUUID("Owner", id));
                Optional.ofNullable((String)mailbox.customName().getValue()).ifPresent(name -> mailboxTag.putString("CustomName", name));
                mailbox.writeQueue(mailboxTag, provider);
                list.add((Object)mailboxTag);
            }
        });
        tag.put("Mailboxes", (Tag)list);
        return tag;
    }

    @Nullable
    private static ResourceKey<Level> createLevelKey(String levelKey) {
        ResourceKey resourceKey;
        if (levelKey.isBlank()) {
            resourceKey = null;
        } else {
            switch (levelKey) {
                case "minecraft:overworld": {
                    resourceKey = Level.OVERWORLD;
                    break;
                }
                case "minecraft:the_nether": {
                    resourceKey = Level.NETHER;
                    break;
                }
                case "minecraft:the_end": {
                    resourceKey = Level.END;
                    break;
                }
                default: {
                    resourceKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)levelKey));
                }
            }
        }
        return resourceKey;
    }

    public static boolean isBannedItem(ItemStack stack) {
        if (((Boolean)Config.SERVER.mailing.banSendingItemsWithInventories.get()).booleanValue() && !stack.getItem().canFitInsideContainerItems()) {
            return true;
        }
        String name = stack.getItem().getDescriptionId();
        return ((List)Config.SERVER.mailing.bannedItems.get()).contains(name);
    }
}

