/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record StackedIngredient(Ingredient ingredient, int count) {
    public static final StackedIngredient EMPTY = new StackedIngredient(Ingredient.EMPTY, 0);
    public static final Codec<StackedIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(o -> o.ingredient), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(o -> o.count)).apply((Applicative)builder, StackedIngredient::new));

    public static StackedIngredient fromNetwork(RegistryFriendlyByteBuf buf) {
        Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
        int count = buf.readInt();
        return new StackedIngredient(ingredient, count);
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)this.ingredient);
        buf.writeInt(this.count);
    }

    public static StackedIngredient of(TagKey<Item> tag, int count) {
        return new StackedIngredient(Ingredient.of(tag), count);
    }

    public static StackedIngredient of(ItemStack stack) {
        return new StackedIngredient(Ingredient.of((ItemStack[])new ItemStack[]{stack}), stack.getCount());
    }

    public static StackedIngredient of(Ingredient ingredient, int count) {
        return new StackedIngredient(ingredient, count);
    }
}

