/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import java.util.Collection;
import java.util.Iterator;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.library.plugins.debug.ObnoxiouslyLargeRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ObnoxiouslyLargeCategory
implements IRecipeCategory<ObnoxiouslyLargeRecipe> {
    public static final RecipeType<ObnoxiouslyLargeRecipe> TYPE = RecipeType.create("jei", "obnoxiously_large_recipe", ObnoxiouslyLargeRecipe.class);
    private static final int WIDTH = 300;
    private static final int HEIGHT = 300;
    private final IIngredientManager ingredientManager;
    private final IDrawable background;
    private final IDrawable slotBackground;
    private final IDrawable icon;

    public ObnoxiouslyLargeCategory(IGuiHelper helper, IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
        this.slotBackground = helper.getSlotDrawable();
        this.background = helper.createBlankDrawable(300 + 2 * this.slotBackground.getWidth(), 300);
        this.icon = Internal.getTextures().getFlameIcon();
    }

    @Override
    public RecipeType<ObnoxiouslyLargeRecipe> getRecipeType() {
        return TYPE;
    }

    @Override
    public Component getTitle() {
        return Component.literal((String)"Obnoxiously Large Recipe Category");
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, ObnoxiouslyLargeRecipe recipe, IFocusGroup focuses) {
        int slotWidth = this.slotBackground.getWidth();
        int slotHeight = this.slotBackground.getHeight();
        int xCount = 300 / slotWidth;
        int yCount = 300 / slotHeight;
        int xOffset = (300 - xCount * slotWidth) / 2;
        int yOffset = (300 - yCount * slotHeight) / 2;
        Collection allItems = this.ingredientManager.getAllIngredients(VanillaTypes.ITEM_STACK);
        Iterator iterator = allItems.iterator();
        for (int x = 0; x < xCount; ++x) {
            for (int y = 0; y < yCount; ++y) {
                int xPos = xOffset + x * slotWidth;
                int yPos = yOffset + y * slotHeight;
                ItemStack stack = (ItemStack)iterator.next();
                builder.addSlot(RecipeIngredientRole.INPUT, xPos + 1, yPos + 1).setBackground(this.slotBackground, -1, -1).addItemStack(stack);
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 300 + slotWidth, 150).setBackground(this.slotBackground, -1, -1).addItemStack((ItemStack)iterator.next());
    }

    @Override
    public ResourceLocation getRegistryName(ObnoxiouslyLargeRecipe recipe) {
        return recipe.getRecipeId();
    }
}

