/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.entity.sync;

import com.mrcrayfish.framework.api.sync.SyncedClassKey;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.entity.sync.DataEntry;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class DataHolder {
    Map<SyncedDataKey<?, ?>, DataEntry<?, ?>> dataMap = new HashMap();
    private Entity entity;
    private boolean dirty;

    public DataHolder setup(Entity entity) {
        if (this.entity == null) {
            this.entity = entity;
        }
        return this;
    }

    <E extends Entity, T> boolean set(E entity, SyncedDataKey<?, ?> key, T value) {
        DataEntry entry = this.dataMap.computeIfAbsent(key, key2 -> new DataEntry(this, key2));
        if (!entry.getValue().equals(value)) {
            boolean dirty = !entity.level().isClientSide() && entry.getKey().syncMode() != SyncedDataKey.SyncMode.NONE;
            entry.setValue(value, dirty);
            this.dirty = dirty;
            return true;
        }
        return false;
    }

    @Nullable
    <E extends Entity, T> T get(SyncedDataKey<E, T> key) {
        return this.dataMap.computeIfAbsent(key, key2 -> new DataEntry(this, key2)).getValue();
    }

    void markDirty() {
        this.dirty = true;
        if (this.entity != null && !this.entity.level().isClientSide() && !this.entity.isRemoved()) {
            SyncedEntityData.instance().markDirty(this.entity);
        }
    }

    boolean isDirty() {
        return this.dirty;
    }

    void clean() {
        this.dirty = false;
        this.dataMap.forEach((key, entry) -> entry.clean());
    }

    List<DataEntry<?, ?>> gatherDirty() {
        return this.dataMap.values().stream().filter(DataEntry::isDirty).filter(entry -> entry.getKey().syncMode() != SyncedDataKey.SyncMode.NONE).collect(Collectors.toList());
    }

    List<DataEntry<?, ?>> gatherAll() {
        return this.dataMap.values().stream().filter(entry -> entry.getKey().syncMode() != SyncedDataKey.SyncMode.NONE).collect(Collectors.toList());
    }

    public ListTag serialize(HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        this.dataMap.forEach((key, entry) -> {
            if (key.save()) {
                CompoundTag keyTag = new CompoundTag();
                keyTag.putString("ClassKey", key.classKey().id().toString());
                keyTag.putString("DataKey", key.id().toString());
                Optional.ofNullable(entry.writeValue(provider)).ifPresent(tag -> keyTag.put("Value", tag));
                list.add((Object)keyTag);
            }
        });
        return list;
    }

    public void deserialize(ListTag listTag, HolderLookup.Provider provider) {
        this.dataMap.clear();
        listTag.forEach(entryTag -> {
            CompoundTag keyTag = (CompoundTag)entryTag;
            ResourceLocation classKey = ResourceLocation.tryParse((String)keyTag.getString("ClassKey"));
            ResourceLocation dataKey = ResourceLocation.tryParse((String)keyTag.getString("DataKey"));
            Tag value = keyTag.get("Value");
            SyncedClassKey<?> syncedClassKey = SyncedEntityData.instance().getClassKey(classKey);
            if (syncedClassKey == null) {
                return;
            }
            Map<ResourceLocation, SyncedDataKey<?, ?>> keys = SyncedEntityData.instance().getDataKeys(syncedClassKey);
            if (keys == null) {
                return;
            }
            SyncedDataKey<?, ?> syncedDataKey = keys.get(dataKey);
            if (syncedDataKey == null || !syncedDataKey.save()) {
                return;
            }
            DataEntry entry = new DataEntry(this, syncedDataKey);
            entry.readValue(value, provider);
            this.dataMap.put(syncedDataKey, entry);
        });
    }
}

