/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.requirement;

import java.util.List;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemRequirement
implements WarpRequirement {
    private ItemStack itemStack;
    private int count;

    public ItemRequirement(ItemStack item, int count) {
        this.itemStack = item;
        this.count = count;
    }

    @Override
    public boolean canAfford(Player player) {
        int count = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack slotStack = player.getInventory().getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)this.itemStack, (ItemStack)slotStack) || (count += slotStack.getCount()) < this.count) continue;
            return true;
        }
        return false;
    }

    @Override
    public void consume(Player player) {
        int consumed = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            int leftToConsume = this.count - consumed;
            ItemStack slotStack = player.getInventory().getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)this.itemStack, (ItemStack)slotStack)) continue;
            int count = Math.min(slotStack.getCount(), leftToConsume);
            slotStack.shrink(count);
            if ((consumed += count) < this.count) continue;
            return;
        }
    }

    @Override
    public void rollback(Player player) {
        ItemStack itemStack;
        for (int added = 0; added < this.count; added += itemStack.getCount()) {
            int leftToAdd = this.count - added;
            itemStack = this.itemStack.copy();
            itemStack.setCount(Math.min(itemStack.getMaxStackSize(), leftToAdd));
            if (player.addItem(itemStack)) continue;
            player.drop(itemStack, false, false);
        }
    }

    @Override
    public void appendHoverText(Player player, List<Component> tooltip) {
        if (this.count > 0) {
            tooltip.add((Component)Component.translatable((String)"gui.waystones.waystone_selection.item_requirement", (Object[])new Object[]{this.count, this.itemStack.getHoverName()}).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.itemStack.isEmpty() || this.count <= 0;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

