/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.world;

import javax.annotation.Nullable;
import journeymap.client.data.DataCache;
import journeymap.client.model.ChunkMD;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public enum JmBlockAccess implements BlockAndTintGetter
{
    INSTANCE;


    public BlockEntity getBlockEntity(@NotNull BlockPos pos) {
        return this.getWorld().getBlockEntity(pos);
    }

    public BlockState getBlockState(@NotNull BlockPos pos) {
        if (!this.isValid(pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        ChunkMD chunkMD = this.getChunkMDFromBlockCoords(pos);
        if (chunkMD != null && chunkMD.hasChunk()) {
            return chunkMD.getChunkBlockState(new BlockPos(pos.getX() & 0xF, pos.getY(), pos.getZ() & 0xF));
        }
        return Blocks.AIR.defaultBlockState();
    }

    public FluidState getFluidState(@NotNull BlockPos blockPos) {
        return this.getWorld().getFluidState(blockPos);
    }

    public int getLightEmission(@NotNull BlockPos p_217298_1_) {
        return this.getWorld().getLightEmission(p_217298_1_);
    }

    public int getMaxLightLevel() {
        return this.getWorld().getMaxLightLevel();
    }

    public int getHeight() {
        return this.getWorld().getHeight();
    }

    public int getMinBuildHeight() {
        return this.getWorld().getMinBuildHeight();
    }

    public int getMaxBuildHeight() {
        return this.getWorld().getMaxBuildHeight();
    }

    public BlockHitResult clip(ClipContext context) {
        return this.getWorld().clip(context);
    }

    @Nullable
    public BlockHitResult clipWithInteractionOverride(Vec3 vec3d, Vec3 vec3d_1, BlockPos blockPos, VoxelShape voxelShape, BlockState blockState) {
        return this.getWorld().clipWithInteractionOverride(vec3d, vec3d_1, blockPos, voxelShape, blockState);
    }

    public Biome getBiome(BlockPos pos) {
        ClientLevel world = Minecraft.getInstance().level;
        return this.getBiome(pos, (Biome)world.registryAccess().registryOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS));
    }

    @Nullable
    public Biome getBiome(BlockPos pos, Biome defaultBiome) {
        IntegratedServer server;
        Biome biome;
        ChunkMD chunkMD = this.getChunkMDFromBlockCoords(pos);
        if (chunkMD != null && chunkMD.hasChunk() && (biome = chunkMD.getBiome(pos)) != null) {
            return biome;
        }
        if (Minecraft.getInstance().hasSingleplayerServer() && (server = Minecraft.getInstance().getSingleplayerServer()) != null) {
            try {
                return (Biome)server.getLevel(DimensionHelper.getDimension((Entity)Minecraft.getInstance().player)).getNoiseBiome(pos.getX() >> 2, pos.getY() >> 2, pos.getZ() >> 2).value();
            }
            catch (Exception e) {
                return (Biome)server.getLevel(DimensionHelper.getDimension((Entity)Minecraft.getInstance().player)).getBiome(pos).value();
            }
        }
        return defaultBiome;
    }

    public Level getWorld() {
        return Minecraft.getInstance().level;
    }

    private boolean isValid(BlockPos pos) {
        return pos.getX() >= -30000000 && pos.getZ() >= -30000000 && pos.getX() < 30000000 && pos.getZ() < 30000000 && pos.getY() >= 0 && pos.getY() < 256;
    }

    @Nullable
    private ChunkMD getChunkMDFromBlockCoords(BlockPos pos) {
        return DataCache.INSTANCE.getChunkMD(ChunkPos.asLong((BlockPos)pos));
    }

    public float getShade(@NotNull Direction p_230487_1_, boolean p_230487_2_) {
        return this.getWorld().getShade(p_230487_1_, p_230487_2_);
    }

    public LevelLightEngine getLightEngine() {
        return this.getWorld().getLightEngine();
    }

    public int getBlockTint(@NotNull BlockPos blockPos, ColorResolver colorResolver) {
        int i = (Integer)Minecraft.getInstance().options.biomeBlendRadius().get();
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int i1 = 0;
        Cursor3D cursor3d = new Cursor3D(blockPos.getX() - i, blockPos.getY(), blockPos.getZ() - i, blockPos.getX() + i, blockPos.getY(), blockPos.getZ() + i);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        while (cursor3d.advance()) {
            blockpos$mutableblockpos.set(cursor3d.nextX(), cursor3d.nextY(), cursor3d.nextZ());
            int j1 = colorResolver.getColor(this.getBiome((BlockPos)blockpos$mutableblockpos), (double)blockpos$mutableblockpos.getX(), (double)blockpos$mutableblockpos.getZ());
            k += (j1 & 0xFF0000) >> 16;
            l += (j1 & 0xFF00) >> 8;
            i1 += j1 & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | i1 / j & 0xFF;
    }

    public int getBrightness(@NotNull LightLayer lightType, @NotNull BlockPos blockPos) {
        return this.getWorld().getBrightness(lightType, blockPos);
    }

    public int getRawBrightness(@NotNull BlockPos blockPosIn, int amount) {
        return this.getWorld().getRawBrightness(blockPosIn, amount);
    }

    public boolean canSeeSky(@NotNull BlockPos blockPosIn) {
        return this.getWorld().canSeeSky(blockPosIn);
    }
}

