/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.world;

import journeymap.client.data.DataCache;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;

public class BiomeColors {
    public static final ColorResolver GRASS_COLOR_RESOLVER = (biome, x, z) -> DataCache.INSTANCE.getBiomeMD(biome).getGrassColor(x, z);
    public static final ColorResolver FOLIAGE_COLOR_RESOLVER = (biome, x, z) -> DataCache.INSTANCE.getBiomeMD(biome).getFoliageColor();
    public static final ColorResolver WATER_COLOR_RESOLVER = (biome, x, z) -> DataCache.INSTANCE.getBiomeMD(biome).getWaterColor();

    private static int getAverageColor(BlockAndTintGetter level, BlockPos blockPos, ColorResolver colorResolver) {
        return level.getBlockTint(blockPos, colorResolver);
    }

    public static int getAverageGrassColor(BlockAndTintGetter level, BlockPos blockPos) {
        return BiomeColors.getAverageColor(level, blockPos, GRASS_COLOR_RESOLVER);
    }

    public static int getAverageFoliageColor(BlockAndTintGetter level, BlockPos blockPos) {
        return BiomeColors.getAverageColor(level, blockPos, FOLIAGE_COLOR_RESOLVER);
    }

    public static int getAverageWaterColor(BlockAndTintGetter level, BlockPos blockPos) {
        return BiomeColors.getAverageColor(level, blockPos, WATER_COLOR_RESOLVER);
    }
}

