/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tools;

import com.mojang.math.Axis;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class EntityTools {
    @Nullable
    public static EntityGenericCar getCarByUUID(Player player, UUID uuid) {
        double distance = 10.0;
        return player.level().getEntitiesOfClass(EntityGenericCar.class, new AABB(player.getX() - distance, player.getY() - distance, player.getZ() - distance, player.getX() + distance, player.getY() + distance, player.getZ() + distance), entity -> entity.getUUID().equals(uuid)).stream().findAny().orElse(null);
    }

    public static void drawCarOnScreen(GuiGraphics graphics, EntityCarBase car, int posX, int posY, float scale, float rotation) {
        graphics.pose().pushPose();
        graphics.pose().translate((double)posX, (double)posY, 100.0);
        graphics.pose().scale(1.0f, 1.0f, -1.0f);
        graphics.pose().scale(scale, scale, scale);
        graphics.pose().mulPose(Axis.YP.rotationDegrees(135.0f + rotation));
        graphics.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
        EntityRenderDispatcher entityrenderermanager = Minecraft.getInstance().getEntityRenderDispatcher();
        entityrenderermanager.setRenderShadow(false);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        entityrenderermanager.render((Entity)car, 0.0, 0.0, 0.0, 0.0f, 1.0f, graphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
        buffer.endBatch();
        entityrenderermanager.setRenderShadow(true);
        graphics.pose().popPose();
    }

    public static interface Renderer {
        public void render(float var1);

        public void tick();
    }

    public static class SimulatedTicker {
        private static final long ONE_TICK = 50000000L;
        private long lastTick;

        public void render(Renderer renderer) {
            long currentNanos = System.nanoTime();
            if (currentNanos - this.lastTick >= 50000000L) {
                renderer.tick();
                this.lastTick = currentNanos;
            }
            renderer.render((float)(currentNanos - this.lastTick) / 5.0E7f);
        }
    }

    public static class SimulatedCarRenderer {
        private float rotation;
        private float rotationPerTick;
        private SimulatedTicker ticker;

        public SimulatedCarRenderer(float rotationPerTick) {
            this.rotationPerTick = rotationPerTick;
            this.ticker = new SimulatedTicker();
        }

        public SimulatedCarRenderer() {
            this(3.6f);
        }

        public void render(final GuiGraphics guiGraphics, final EntityCarBase car, final int posX, final int posY, final int scale) {
            this.ticker.render(new Renderer(){

                @Override
                public void render(float partialTicks) {
                    EntityTools.drawCarOnScreen(guiGraphics, car, posX, posY, scale, rotation + rotationPerTick * partialTicks);
                }

                @Override
                public void tick() {
                    rotation += rotationPerTick;
                    if (rotation >= 360.0f) {
                        rotation = 0.0f;
                    }
                }
            });
        }
    }

    public static class CarRenderer {
        private float rotation;
        private float rotationPerTick;
        private Minecraft minecraft;

        public CarRenderer(float rotationPerTick) {
            this.rotationPerTick = rotationPerTick;
            this.minecraft = Minecraft.getInstance();
        }

        public CarRenderer() {
            this(3.6f);
        }

        public void tick() {
            this.rotation += this.rotationPerTick;
            if (this.rotation >= 360.0f) {
                this.rotation = 0.0f;
            }
        }

        public void render(GuiGraphics guiGraphics, EntityCarBase car, int posX, int posY, int scale) {
            EntityTools.drawCarOnScreen(guiGraphics, car, posX, posY, scale, this.rotation + this.rotationPerTick * this.minecraft.getTimer().getRealtimeDeltaTicks());
        }
    }
}

