/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.corelib.net.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageStartFuel
implements Message<MessageStartFuel> {
    public static final CustomPacketPayload.Type<MessageStartFuel> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"start_fuel"));
    private boolean start;
    private BlockPos pos;

    public MessageStartFuel() {
    }

    public MessageStartFuel(BlockPos pos, boolean start) {
        this.pos = pos;
        this.start = start;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        BlockEntity blockEntity = sender.level().getBlockEntity(this.pos);
        if (blockEntity instanceof TileEntityGasStation) {
            TileEntityGasStation gasStation = (TileEntityGasStation)blockEntity;
            gasStation.setFueling(this.start);
            gasStation.synchronize();
        }
    }

    @Override
    public MessageStartFuel fromBytes(RegistryFriendlyByteBuf buf) {
        this.start = buf.readBoolean();
        this.pos = buf.readBlockPos();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.start);
        buf.writeBlockPos(this.pos);
    }

    @Override
    public CustomPacketPayload.Type<MessageStartFuel> type() {
        return TYPE;
    }
}

