/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.corelib.net.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageGasStationAdminAmount
implements Message<MessageGasStationAdminAmount> {
    public static final CustomPacketPayload.Type<MessageGasStationAdminAmount> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"gas_station_amount"));
    private BlockPos pos;
    private int amount;

    public MessageGasStationAdminAmount() {
    }

    public MessageGasStationAdminAmount(BlockPos pos, int amount) {
        this.pos = pos;
        this.amount = amount;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        BlockEntity blockEntity = sender.level().getBlockEntity(this.pos);
        if (blockEntity instanceof TileEntityGasStation) {
            TileEntityGasStation gasStation = (TileEntityGasStation)blockEntity;
            gasStation.setTradeAmount(this.amount);
        }
    }

    @Override
    public MessageGasStationAdminAmount fromBytes(RegistryFriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.amount = buf.readInt();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.amount);
    }

    @Override
    public CustomPacketPayload.Type<MessageGasStationAdminAmount> type() {
        return TYPE;
    }
}

