/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.integration.waila;

import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.FluidStack;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class HUDHandlerTank
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final HUDHandlerTank INSTANCE = new HUDHandlerTank();
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"tank");

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        FluidStack stack = FluidStack.parseOptional((HolderLookup.Provider)blockAccessor.getBlockEntity().getLevel().registryAccess(), (CompoundTag)blockAccessor.getServerData().getCompound("fluid"));
        if (stack.isEmpty()) {
            iTooltip.add((Component)Component.translatable((String)"tooltip.waila.tank.no_fluid"));
        } else {
            iTooltip.add((Component)Component.translatable((String)"tooltip.waila.tank.fluid", (Object[])new Object[]{stack.getHoverName()}));
            iTooltip.add((Component)Component.translatable((String)"tooltip.waila.tank.amount", (Object[])new Object[]{stack.getAmount(), 16000}));
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        TileEntityTank tank = (TileEntityTank)blockAccessor.getBlockEntity();
        compoundTag.put("fluid", tank.getFluid().save((HolderLookup.Provider)blockAccessor.getBlockEntity().getLevel().registryAccess()));
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

