/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.entity.car.base.EntityCarFuelBase;
import de.maxhenkel.car.gui.ContainerCar;
import de.maxhenkel.car.gui.ContainerCarInventory;
import de.maxhenkel.car.items.ItemCanister;
import de.maxhenkel.car.sounds.ModSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public abstract class EntityCarInventoryBase
extends EntityCarFuelBase
implements Container {
    protected Container internalInventory;
    protected Container externalInventory;
    protected Container partInventory;
    protected FluidStack fluidInventory;
    private IFluidHandler inventoryFluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return EntityCarInventoryBase.this.fluidInventory;
        }

        public int getTankCapacity(int tank) {
            return EntityCarInventoryBase.this.getFluidInventorySize();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (EntityCarInventoryBase.this.fluidInventory.isEmpty()) {
                int amount = Math.min(resource.getAmount(), EntityCarInventoryBase.this.getFluidInventorySize());
                if (action.execute()) {
                    EntityCarInventoryBase.this.fluidInventory = new FluidStack(resource.getFluid(), amount);
                }
                return amount;
            }
            if (resource.getFluid().equals(EntityCarInventoryBase.this.fluidInventory.getFluid())) {
                int amount = Math.min(resource.getAmount(), EntityCarInventoryBase.this.getFluidInventorySize() - EntityCarInventoryBase.this.fluidInventory.getAmount());
                if (action.execute()) {
                    EntityCarInventoryBase.this.fluidInventory.setAmount(EntityCarInventoryBase.this.fluidInventory.getAmount() + amount);
                }
                return amount;
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (EntityCarInventoryBase.this.fluidInventory.isEmpty()) {
                return FluidStack.EMPTY;
            }
            if (EntityCarInventoryBase.this.fluidInventory.getFluid().equals(resource.getFluid())) {
                int amount = Math.min(resource.getAmount(), EntityCarInventoryBase.this.fluidInventory.getAmount());
                Fluid f = EntityCarInventoryBase.this.fluidInventory.getFluid();
                if (action.execute()) {
                    EntityCarInventoryBase.this.fluidInventory.setAmount(EntityCarInventoryBase.this.fluidInventory.getAmount() - amount);
                    if (EntityCarInventoryBase.this.fluidInventory.getAmount() <= 0) {
                        EntityCarInventoryBase.this.fluidInventory = FluidStack.EMPTY;
                    }
                }
                return new FluidStack(f, amount);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (EntityCarInventoryBase.this.fluidInventory.isEmpty()) {
                return FluidStack.EMPTY;
            }
            int amount = Math.min(maxDrain, EntityCarInventoryBase.this.fluidInventory.getAmount());
            Fluid f = EntityCarInventoryBase.this.fluidInventory.getFluid();
            if (action.execute()) {
                EntityCarInventoryBase.this.fluidInventory.setAmount(EntityCarInventoryBase.this.fluidInventory.getAmount() - amount);
                if (EntityCarInventoryBase.this.fluidInventory.getAmount() <= 0) {
                    EntityCarInventoryBase.this.fluidInventory = FluidStack.EMPTY;
                }
            }
            return new FluidStack(f, amount);
        }
    };

    public EntityCarInventoryBase(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.internalInventory = new SimpleContainer(27);
        this.externalInventory = new SimpleContainer(0);
        this.partInventory = new SimpleContainer(15);
        this.fluidInventory = FluidStack.EMPTY;
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.canPlayerAccessInventoryExternal(player) && player.isShiftKeyDown()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.isEmpty()) {
                IFluidHandler handler;
                if (stack.getItem() instanceof ItemCanister) {
                    boolean success = ItemCanister.fillCanister(stack, this);
                    if (success) {
                        ModSounds.playSound(SoundEvents.BREWING_STAND_BREW, this.level(), this.blockPosition(), null, SoundSource.BLOCKS);
                    }
                    return InteractionResult.CONSUME;
                }
                if (this.getFluidInventorySize() > 0 && (handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null)) != null) {
                    FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
                    if (!fluidStack.isEmpty() && EntityCarInventoryBase.handleEmpty(stack, this.getInventoryFluidHandler(), player, hand)) {
                        return InteractionResult.CONSUME;
                    }
                    if (EntityCarInventoryBase.handleFill(stack, this.getInventoryFluidHandler(), player, hand)) {
                        return InteractionResult.CONSUME;
                    }
                }
            }
            if (!this.level().isClientSide) {
                if (this.externalInventory.getContainerSize() <= 0) {
                    this.openCarGUI(player);
                } else if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.openMenu(new MenuProvider(){

                        public Component getDisplayName() {
                            return EntityCarInventoryBase.this.getDisplayName();
                        }

                        @Nullable
                        public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                            return new ContainerCarInventory(i, EntityCarInventoryBase.this, playerInventory);
                        }
                    }, packetBuffer -> packetBuffer.writeUUID(this.getUUID()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public static boolean handleEmpty(ItemStack stack, IFluidHandler handler, Player playerIn, InteractionHand hand) {
        InvWrapper inv = new InvWrapper((Container)playerIn.getInventory());
        FluidActionResult res = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true);
        if (res.isSuccess()) {
            playerIn.setItemInHand(hand, res.result);
            return true;
        }
        return false;
    }

    public static boolean handleFill(ItemStack stack, IFluidHandler handler, Player playerIn, InteractionHand hand) {
        InvWrapper inv = new InvWrapper((Container)playerIn.getInventory());
        FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true);
        if (result.isSuccess()) {
            playerIn.setItemInHand(hand, result.result);
            return true;
        }
        return false;
    }

    public abstract int getFluidInventorySize();

    public boolean canPlayerAccessInventoryExternal(Player player) {
        return true;
    }

    public Container getPartInventory() {
        return this.partInventory;
    }

    @Override
    public void destroyCar(Player player, boolean dropParts) {
        super.destroyCar(player, dropParts);
        Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        Containers.dropContents((Level)this.level(), (Entity)this, (Container)this.externalInventory);
        if (dropParts) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this.partInventory);
        }
    }

    @Override
    public void openCarGUI(Player player) {
        super.openCarGUI(player);
        if (!this.level().isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return EntityCarInventoryBase.this.getDisplayName();
                }

                @Nullable
                public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                    return new ContainerCar(i, EntityCarInventoryBase.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.writeUUID(this.getUUID()));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        ItemUtils.readInventory((HolderLookup.Provider)this.registryAccess(), compound, "int_inventory", this.internalInventory);
        this.externalInventory = new SimpleContainer(compound.getInt("external_inventory_size"));
        ItemUtils.readInventory((HolderLookup.Provider)this.registryAccess(), compound, "external_inventory", this.externalInventory);
        ItemUtils.readInventory((HolderLookup.Provider)this.registryAccess(), compound, "parts", this.partInventory);
        if (compound.contains("fluid_inventory")) {
            this.fluidInventory = FluidStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compound.getCompound("fluid_inventory"));
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ItemUtils.saveInventory((HolderLookup.Provider)this.registryAccess(), compound, "int_inventory", this.internalInventory);
        compound.putInt("external_inventory_size", this.externalInventory.getContainerSize());
        ItemUtils.saveInventory((HolderLookup.Provider)this.registryAccess(), compound, "external_inventory", this.externalInventory);
        ItemUtils.saveInventory((HolderLookup.Provider)this.registryAccess(), compound, "parts", this.partInventory);
        if (!this.fluidInventory.isEmpty()) {
            compound.put("fluid_inventory", this.fluidInventory.save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    public IFluidHandler getInventoryFluidHandler() {
        return this.inventoryFluidHandler;
    }

    public int getContainerSize() {
        return this.internalInventory.getContainerSize();
    }

    public ItemStack getItem(int index) {
        return this.internalInventory.getItem(index);
    }

    public ItemStack removeItem(int index, int count) {
        return this.internalInventory.removeItem(index, count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.internalInventory.removeItemNoUpdate(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.internalInventory.setItem(index, stack);
    }

    public int getMaxStackSize() {
        return this.internalInventory.getMaxStackSize();
    }

    public void setChanged() {
        this.internalInventory.setChanged();
    }

    public boolean stillValid(Player player) {
        return this.internalInventory.stillValid(player);
    }

    public boolean isEmpty() {
        return this.internalInventory.isEmpty();
    }

    public void startOpen(Player player) {
        this.internalInventory.startOpen(player);
    }

    public void stopOpen(Player player) {
        this.internalInventory.stopOpen(player);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.internalInventory.canPlaceItem(index, stack);
    }

    public void clearContent() {
        this.internalInventory.clearContent();
    }

    public Container getExternalInventory() {
        return this.externalInventory;
    }
}

