/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.config;

import de.maxhenkel.car.corelib.config.ConfigBase;
import de.maxhenkel.car.corelib.tag.Tag;
import de.maxhenkel.car.corelib.tag.TagUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerConfig
extends ConfigBase {
    public final ModConfigSpec.IntValue backmixReactorEnergyStorage;
    public final ModConfigSpec.IntValue backmixReactorEnergyUsage;
    public final ModConfigSpec.IntValue backmixReactorFluidStorage;
    public final ModConfigSpec.IntValue backmixReactorGeneratingTime;
    public final ModConfigSpec.IntValue backmixReactorMixGeneration;
    public final ModConfigSpec.IntValue backmixReactorMethanolUsage;
    public final ModConfigSpec.IntValue backmixReactorCanolaUsage;
    public final ModConfigSpec.IntValue blastFurnaceEnergyStorage;
    public final ModConfigSpec.IntValue blastFurnaceFluidStorage;
    public final ModConfigSpec.IntValue oilMillEnergyStorage;
    public final ModConfigSpec.IntValue oilMillFluidStorage;
    public final ModConfigSpec.IntValue cableTransferRate;
    public final ModConfigSpec.IntValue dynamoEnergyStorage;
    public final ModConfigSpec.IntValue dynamoEnergyGeneration;
    public final ModConfigSpec.IntValue fluidExtractorDrainSpeed;
    public final ModConfigSpec.IntValue gasStationTransferRate;
    public final ModConfigSpec.ConfigValue<List<? extends String>> gasStationValidFuels;
    public final ModConfigSpec.IntValue generatorEnergyStorage;
    public final ModConfigSpec.IntValue generatorFluidStorage;
    public final ModConfigSpec.IntValue generatorEnergyGeneration;
    public final ModConfigSpec.ConfigValue<List<? extends String>> generatorValidFuels;
    public final ModConfigSpec.IntValue splitTankFluidStorage;
    public final ModConfigSpec.IntValue splitTankGeneratingTime;
    public final ModConfigSpec.IntValue splitTankMixUsage;
    public final ModConfigSpec.IntValue splitTankGlycerinGeneration;
    public final ModConfigSpec.IntValue splitTankBioDieselGeneration;
    public final ModConfigSpec.DoubleValue repairKitRepairAmount;
    public final ModConfigSpec.IntValue canisterMaxFuel;
    public final ModConfigSpec.DoubleValue carOffroadSpeed;
    public final ModConfigSpec.DoubleValue carOnroadSpeed;
    public final ModConfigSpec.ConfigValue<List<? extends String>> carDriveBlocks;
    public final ModConfigSpec.BooleanValue collideWithEntities;
    public final ModConfigSpec.BooleanValue damageEntities;
    public final ModConfigSpec.BooleanValue hornFlee;
    public final ModConfigSpec.BooleanValue useBattery;
    public final ModConfigSpec.IntValue tankSmallMaxFuel;
    public final ModConfigSpec.IntValue tankMediumMaxFuel;
    public final ModConfigSpec.IntValue tankLargeMaxFuel;
    public final ModConfigSpec.DoubleValue engine6CylinderFuelEfficiency;
    public final ModConfigSpec.DoubleValue engine3CylinderFuelEfficiency;
    public final ModConfigSpec.DoubleValue engineTruckFuelEfficiency;
    public final ModConfigSpec.DoubleValue engine6CylinderAcceleration;
    public final ModConfigSpec.DoubleValue engine3CylinderAcceleration;
    public final ModConfigSpec.DoubleValue engineTruckAcceleration;
    public final ModConfigSpec.DoubleValue engine6CylinderMaxSpeed;
    public final ModConfigSpec.DoubleValue engine3CylinderMaxSpeed;
    public final ModConfigSpec.DoubleValue engineTruckMaxSpeed;
    public final ModConfigSpec.DoubleValue engine6CylinderMaxReverseSpeed;
    public final ModConfigSpec.DoubleValue engine3CylinderMaxReverseSpeed;
    public final ModConfigSpec.DoubleValue engineTruckMaxReverseSpeed;
    public final ModConfigSpec.DoubleValue bodyBigWoodFuelEfficiency;
    public final ModConfigSpec.DoubleValue bodyBigWoodAcceleration;
    public final ModConfigSpec.DoubleValue bodyBigWoodMaxSpeed;
    public final ModConfigSpec.DoubleValue bodyWoodFuelEfficiency;
    public final ModConfigSpec.DoubleValue bodyWoodAcceleration;
    public final ModConfigSpec.DoubleValue bodyWoodMaxSpeed;
    public final ModConfigSpec.DoubleValue bodySportFuelEfficiency;
    public final ModConfigSpec.DoubleValue bodySportAcceleration;
    public final ModConfigSpec.DoubleValue bodySportMaxSpeed;
    public final ModConfigSpec.DoubleValue bodySUVFuelEfficiency;
    public final ModConfigSpec.DoubleValue bodySUVAcceleration;
    public final ModConfigSpec.DoubleValue bodySUVMaxSpeed;
    public final ModConfigSpec.DoubleValue bodyTransporterFuelEfficiency;
    public final ModConfigSpec.DoubleValue bodyTransporterAcceleration;
    public final ModConfigSpec.DoubleValue bodyTransporterMaxSpeed;
    public List<Tag<Fluid>> gasStationValidFuelList = new ArrayList<Tag<Fluid>>();
    public List<Tag<Fluid>> generatorValidFuelList = new ArrayList<Tag<Fluid>>();
    public List<Tag<Block>> carDriveBlockList = new ArrayList<Tag<Block>>();

    public ServerConfig(ModConfigSpec.Builder builder) {
        super(builder);
        this.backmixReactorEnergyStorage = builder.defineInRange("machines.backmix_reactor.energy_storage", 10000, 100, Short.MAX_VALUE);
        this.backmixReactorEnergyUsage = builder.defineInRange("machines.backmix_reactor.energy_usage", 10, 1, Short.MAX_VALUE);
        this.backmixReactorFluidStorage = builder.defineInRange("machines.backmix_reactor.fluid_storage", 3000, 1000, Short.MAX_VALUE);
        this.backmixReactorGeneratingTime = builder.defineInRange("machines.backmix_reactor.generating_time", 200, 10, Short.MAX_VALUE);
        this.backmixReactorMixGeneration = builder.defineInRange("machines.backmix_reactor.mix_generation", 100, 1, Short.MAX_VALUE);
        this.backmixReactorMethanolUsage = builder.defineInRange("machines.backmix_reactor.methanol_usage", 50, 1, Short.MAX_VALUE);
        this.backmixReactorCanolaUsage = builder.defineInRange("machines.backmix_reactor.canola_usage", 50, 1, Short.MAX_VALUE);
        this.blastFurnaceEnergyStorage = builder.defineInRange("machines.blast_furnace.energy_storage", 10000, 1000, Short.MAX_VALUE);
        this.blastFurnaceFluidStorage = builder.defineInRange("machines.blast_furnace.fluid_storage", 3000, 1000, Short.MAX_VALUE);
        this.oilMillEnergyStorage = builder.defineInRange("machines.oil_mill.energy_storage", 10000, 1000, Short.MAX_VALUE);
        this.oilMillFluidStorage = builder.defineInRange("machines.oil_mill.fluid_storage", 3000, 1000, Short.MAX_VALUE);
        this.cableTransferRate = builder.defineInRange("machines.cable.transfer_rate", 256, 64, Short.MAX_VALUE);
        this.dynamoEnergyStorage = builder.defineInRange("machines.dynamo.energy_storage", 1000, 100, Short.MAX_VALUE);
        this.dynamoEnergyGeneration = builder.defineInRange("machines.dynamo.energy_generation", 25, 1, Short.MAX_VALUE);
        this.fluidExtractorDrainSpeed = builder.defineInRange("machines.fluid_extractor.drain_speed", 25, 5, Short.MAX_VALUE);
        this.gasStationTransferRate = builder.defineInRange("machines.gas_station.transfer_rate", 5, 1, Short.MAX_VALUE);
        this.gasStationValidFuels = builder.comment("If it starts with '#' it is a tag").defineList("machines.gas_station.valid_fuels", Collections.singletonList("#car:gas_station"), Objects::nonNull);
        this.generatorEnergyStorage = builder.defineInRange("machines.generator.energy_storage", 30000, 1000, Short.MAX_VALUE);
        this.generatorFluidStorage = builder.defineInRange("machines.generator.fluid_storage", 3000, 1000, Short.MAX_VALUE);
        this.generatorEnergyGeneration = builder.defineInRange("machines.generator.energy_generation", 500, 1, Short.MAX_VALUE);
        this.generatorValidFuels = builder.comment("If it starts with '#' it is a tag").defineList("machines.generator.valid_fuels", Collections.singletonList("#car:generator"), Objects::nonNull);
        this.splitTankFluidStorage = builder.defineInRange("machines.split_tank.fluid_storage", 3000, 1000, Short.MAX_VALUE);
        this.splitTankGeneratingTime = builder.defineInRange("machines.split_tank.generating_time", 800, 10, Short.MAX_VALUE);
        this.splitTankMixUsage = builder.defineInRange("machines.split_tank.mix_usage", 100, 1, Short.MAX_VALUE);
        this.splitTankGlycerinGeneration = builder.defineInRange("machines.split_tank.glycerin_generation", 10, 1, Short.MAX_VALUE);
        this.splitTankBioDieselGeneration = builder.defineInRange("machines.split_tank.bio_diesel_generation", 100, 1, Short.MAX_VALUE);
        this.repairKitRepairAmount = builder.defineInRange("items.repair_kit.repair_amount", 5.0, (double)0.1f, 100.0);
        this.canisterMaxFuel = builder.defineInRange("items.canister.max_fuel", 100, 1, 1000);
        this.collideWithEntities = builder.comment("Whether the cars should collide with other entities (except cars)").define("car.collide_with_entities", false);
        this.damageEntities = builder.comment("Whether the cars should damage other entities on collision").define("car.damage_entities", true);
        this.hornFlee = builder.comment("Whether animals flee from the car when the horn is activted").define("car.horn_flee", true);
        this.useBattery = builder.comment("True if starting the car should use battery").define("car.use_battery", true);
        this.carOffroadSpeed = builder.comment("The speed modifier for cars on non road blocks").defineInRange("car.offroad_speed_modifier", 1.0, 0.001, 10.0);
        this.carOnroadSpeed = builder.comment(new String[]{"The speed modifier for cars on road blocks", "On road blocks are defined in the config section 'road_blocks'"}).defineInRange("car.onroad_speed_modifier", 1.0, 0.001, 10.0);
        this.carDriveBlocks = builder.comment("If it starts with '#' it is a tag").defineList("car.road_blocks.blocks", Collections.singletonList("#car:drivable_blocks"), Objects::nonNull);
        this.tankSmallMaxFuel = builder.defineInRange("car.parts.small_tank.max_fuel", 500, 100, 100000);
        this.tankMediumMaxFuel = builder.defineInRange("car.parts.medium_tank.max_fuel", 1000, 100, 100000);
        this.tankLargeMaxFuel = builder.defineInRange("car.parts.large_tank.max_fuel", 1500, 100, 100000);
        this.engine6CylinderFuelEfficiency = builder.defineInRange("car.parts.engine_6_cylinder.fuel_efficiency", 0.25, 0.001, 10.0);
        this.engine3CylinderFuelEfficiency = builder.defineInRange("car.parts.engine_3_cylinder.fuel_efficiency", 0.5, 0.001, 10.0);
        this.engineTruckFuelEfficiency = builder.defineInRange("car.parts.engine_truck.fuel_efficiency", 0.7, 0.001, 10.0);
        this.engine6CylinderAcceleration = builder.defineInRange("car.parts.engine_6_cylinder.acceleration", 0.04, 0.001, 10.0);
        this.engine3CylinderAcceleration = builder.defineInRange("car.parts.engine_3_cylinder.acceleration", 0.035, 0.001, 10.0);
        this.engineTruckAcceleration = builder.defineInRange("car.parts.engine_truck.acceleration", 0.032, 0.001, 10.0);
        this.engine6CylinderMaxSpeed = builder.defineInRange("car.parts.engine_6_cylinder.max_speed", 0.75, 0.001, 10.0);
        this.engine3CylinderMaxSpeed = builder.defineInRange("car.parts.engine_3_cylinder.max_speed", 0.65, 0.001, 10.0);
        this.engineTruckMaxSpeed = builder.defineInRange("car.parts.engine_truck.max_speed", 0.6, 0.001, 10.0);
        this.engine6CylinderMaxReverseSpeed = builder.defineInRange("car.parts.engine_6_cylinder.max_reverse_speed", 0.2, 0.001, 10.0);
        this.engine3CylinderMaxReverseSpeed = builder.defineInRange("car.parts.engine_3_cylinder.max_reverse_speed", 0.2, 0.001, 10.0);
        this.engineTruckMaxReverseSpeed = builder.defineInRange("car.parts.engine_truck.max_reverse_speed", 0.15, 0.001, 10.0);
        this.bodyBigWoodFuelEfficiency = builder.defineInRange("car.parts.body_big_wood.fuel_efficiency", 0.7, 0.001, 10.0);
        this.bodyBigWoodAcceleration = builder.defineInRange("car.parts.body_big_wood.acceleration", 0.95, 0.001, 10.0);
        this.bodyBigWoodMaxSpeed = builder.defineInRange("car.parts.body_big_wood.max_speed", 0.85, 0.001, 10.0);
        this.bodyWoodFuelEfficiency = builder.defineInRange("car.parts.body_wood.fuel_efficiency", 0.8, 0.001, 10.0);
        this.bodyWoodAcceleration = builder.defineInRange("car.parts.body_wood.acceleration", 1.0, 0.001, 10.0);
        this.bodyWoodMaxSpeed = builder.defineInRange("car.parts.body_wood.max_speed", 0.9, 0.001, 10.0);
        this.bodySportFuelEfficiency = builder.defineInRange("car.parts.body_sport.fuel_efficiency", 0.9, 0.001, 10.0);
        this.bodySportAcceleration = builder.defineInRange("car.parts.body_sport.acceleration", 1.0, 0.001, 10.0);
        this.bodySportMaxSpeed = builder.defineInRange("car.parts.body_sport.max_speed", 1.0, 0.001, 10.0);
        this.bodySUVFuelEfficiency = builder.defineInRange("car.parts.body_suv.fuel_efficiency", 0.6, 0.001, 10.0);
        this.bodySUVAcceleration = builder.defineInRange("car.parts.body_suv.acceleration", 0.8, 0.001, 10.0);
        this.bodySUVMaxSpeed = builder.defineInRange("car.parts.body_suv.max_speed", 0.7, 0.001, 10.0);
        this.bodyTransporterFuelEfficiency = builder.defineInRange("car.parts.body_transporter.fuel_efficiency", 0.6, 0.001, 10.0);
        this.bodyTransporterAcceleration = builder.defineInRange("car.parts.body_transporter.acceleration", 0.8, 0.001, 10.0);
        this.bodyTransporterMaxSpeed = builder.defineInRange("car.parts.body_transporter.max_speed", 0.765, 0.001, 10.0);
    }

    @Override
    public void onReload(ModConfigEvent.Reloading event) {
        super.onReload(event);
        this.onConfigChanged();
    }

    @Override
    public void onLoad(ModConfigEvent.Loading evt) {
        super.onLoad(evt);
        this.onConfigChanged();
    }

    private void onConfigChanged() {
        this.gasStationValidFuelList = ((List)this.gasStationValidFuels.get()).stream().map(TagUtils::getFluid).filter(Objects::nonNull).collect(Collectors.toList());
        this.generatorValidFuelList = ((List)this.generatorValidFuels.get()).stream().map(TagUtils::getFluid).filter(Objects::nonNull).collect(Collectors.toList());
        this.carDriveBlockList = ((List)this.carDriveBlocks.get()).stream().map(TagUtils::getBlock).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

