/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.net.MessageSyncTileEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Nameable;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class TileEntityBase
extends BlockEntity
implements Nameable {
    private Component name;
    private CompoundTag compoundLast;

    public TileEntityBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void synchronize() {
        Level level;
        if (!this.level.isClientSide && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CompoundTag last = this.getUpdateTag((HolderLookup.Provider)serverLevel.registryAccess());
            if (this.compoundLast == null || !this.compoundLast.equals((Object)last)) {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new MessageSyncTileEntity(this.worldPosition, last), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.compoundLast = last;
            }
        }
    }

    public void synchronize(int ticks) {
        if (this.level.getGameTime() % (long)ticks == 0L) {
            this.synchronize();
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getUpdateTag(provider);
        this.saveAdditional(updateTag, provider);
        return updateTag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public abstract Component getTranslatedName();

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component getName() {
        return this.name != null ? this.name : this.getTranslatedName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public abstract ContainerData getFields();

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.name != null) {
            compound.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)provider));
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains("CustomName")) {
            this.name = Component.Serializer.fromJson((String)compound.getString("CustomName"), (HolderLookup.Provider)provider);
        }
        super.loadAdditional(compound, provider);
    }

    @Nullable
    public IFluidHandler getFluidHandler() {
        TileEntityBase tileEntityBase = this;
        if (tileEntityBase instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)tileEntityBase;
            return fluidHandler;
        }
        return null;
    }

    @Nullable
    public IEnergyStorage getEnergyStorage() {
        TileEntityBase tileEntityBase = this;
        if (tileEntityBase instanceof IEnergyStorage) {
            IEnergyStorage energyStorage = (IEnergyStorage)tileEntityBase;
            return energyStorage;
        }
        return null;
    }

    @Nullable
    public IItemHandler getItemHandler() {
        TileEntityBase tileEntityBase = this;
        if (tileEntityBase instanceof IItemHandler) {
            IItemHandler itemHandler = (IItemHandler)tileEntityBase;
            return itemHandler;
        }
        return null;
    }
}

