/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.client.screen;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.client.screen.BalmScreenFactory;
import net.blay09.mods.balm.api.client.screen.BalmScreens;
import net.blay09.mods.balm.mixin.ScreenAccessor;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class NeoForgeBalmScreens
implements BalmScreens {
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();

    @Override
    public <T extends AbstractContainerMenu, S extends Screen> void registerScreen(Supplier<MenuType<? extends T>> type, BalmScreenFactory<T, S> screenFactory) {
        this.getActiveRegistrations().menuTypes.add(Pair.of(type::get, screenFactory));
    }

    private static <TMenu extends AbstractContainerMenu, TScreen extends Screen> void registerScreenImmediate(RegisterMenuScreensEvent event, MenuType<TMenu> type, BalmScreenFactory<TMenu, TScreen> screenFactory) {
        event.register(type, screenFactory::create);
    }

    @Override
    public AbstractWidget addRenderableWidget(Screen screen, AbstractWidget widget) {
        ScreenAccessor accessor = (ScreenAccessor)screen;
        accessor.balm_getChildren().add((GuiEventListener)widget);
        accessor.balm_getRenderables().add((Renderable)widget);
        accessor.balm_getNarratables().add((NarratableEntry)widget);
        return widget;
    }

    public void register(String modId, IEventBus eventBus) {
        eventBus.register((Object)this.getRegistrations(modId));
    }

    private Registrations getActiveRegistrations() {
        return this.getRegistrations(ModLoadingContext.get().getActiveNamespace());
    }

    private Registrations getRegistrations(String modId) {
        return this.registrations.computeIfAbsent(modId, it -> new Registrations());
    }

    private static class Registrations {
        public final List<Pair<Supplier<MenuType<?>>, BalmScreenFactory<?, ?>>> menuTypes = new ArrayList();

        private Registrations() {
        }

        @SubscribeEvent
        public void registerMenuScreens(RegisterMenuScreensEvent event) {
            for (Pair<Supplier<MenuType<?>>, BalmScreenFactory<?, ?>> entry : this.menuTypes) {
                MenuType menuType = (MenuType)((Supplier)entry.getFirst()).get();
                BalmScreenFactory screenFactory = (BalmScreenFactory)entry.getSecond();
                NeoForgeBalmScreens.registerScreenImmediate(event, menuType, screenFactory);
            }
        }
    }
}

