/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.render.batch;

import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class LimitedQuadItemModel
implements BakedModel {
    private final BakedModel bakedmodel;
    @Nullable
    private List<BakedQuad> quads;

    public LimitedQuadItemModel(BakedModel bakedmodel) {
        this.bakedmodel = bakedmodel;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction direction, RandomSource randomSource) {
        if (direction == null) {
            if (this.quads == null) {
                this.quads = this.bakedmodel.getQuads(blockState, null, randomSource).stream().filter(q -> q.getDirection() == Direction.SOUTH).toList();
            }
            return this.quads;
        }
        return List.of();
    }

    public boolean useAmbientOcclusion() {
        return this.bakedmodel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.bakedmodel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.bakedmodel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.bakedmodel.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.bakedmodel.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return this.bakedmodel.getTransforms();
    }

    public ItemOverrides getOverrides() {
        return this.bakedmodel.getOverrides();
    }
}

