/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients.subtypes;

import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.ingredients.subtypes.SubtypeInterpreters;
import org.jetbrains.annotations.Nullable;

public class SubtypeManager
implements ISubtypeManager {
    private final SubtypeInterpreters interpreters;

    public SubtypeManager(SubtypeInterpreters interpreters) {
        this.interpreters = interpreters;
    }

    @Override
    @Nullable
    public <T> Object getSubtypeData(IIngredientTypeWithSubtypes<?, T> ingredientType, T ingredient, UidContext context) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        ErrorUtil.checkNotNull(context, "type");
        return this.interpreters.get(ingredientType, ingredient).map(subtypeInterpreter -> subtypeInterpreter.getSubtypeData(ingredient, context)).orElse(null);
    }

    @Override
    public <T> String getSubtypeInfo(IIngredientTypeWithSubtypes<?, T> ingredientType, T ingredient, UidContext context) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        ErrorUtil.checkNotNull(context, "context");
        return this.interpreters.get(ingredientType, ingredient).map(subtypeInterpreter -> subtypeInterpreter.getLegacyStringSubtypeInfo(ingredient, context)).orElse("");
    }

    @Override
    public <T, B> boolean hasSubtypes(IIngredientTypeWithSubtypes<B, T> ingredientType, T ingredient) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        return this.interpreters.contains(ingredientType, ingredient);
    }
}

