/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients.itemStacks;

import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.library.ingredients.itemStacks.NormalizedTypedItemStack;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record TypedItemStack(Holder<Item> itemHolder, DataComponentPatch dataComponentPatch, int count) implements ITypedIngredient<ItemStack>
{
    public static ITypedIngredient<ItemStack> create(ItemStack ingredient) {
        if (ingredient.getCount() == 1) {
            return NormalizedTypedItemStack.create(ingredient);
        }
        return new TypedItemStack((Holder<Item>)ingredient.getItemHolder(), ingredient.getComponentsPatch(), ingredient.getCount());
    }

    @Override
    public ItemStack getIngredient() {
        return new ItemStack(this.itemHolder, this.count, this.dataComponentPatch);
    }

    @Override
    public Optional<ItemStack> getItemStack() {
        return Optional.of(this.getIngredient());
    }

    @Override
    public IIngredientType<ItemStack> getType() {
        return VanillaTypes.ITEM_STACK;
    }

    @Override
    public String toString() {
        return "TypedItemStack{itemHolder=" + String.valueOf(this.itemHolder) + ", dataComponentPatch=" + String.valueOf(this.dataComponentPatch) + ", count=" + this.count + "}";
    }
}

