/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.block.BOPBlocks;
import com.mojang.serialization.MapCodec;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LumaloopPlantBlock
extends GrowingPlantBodyBlock {
    public static final MapCodec<LumaloopPlantBlock> CODEC = LumaloopPlantBlock.simpleCodec(LumaloopPlantBlock::new);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public LumaloopPlantBlock(BlockBehaviour.Properties p_i241195_1_) {
        super(p_i241195_1_, Direction.UP, SHAPE, false);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<LumaloopPlantBlock> codec() {
        return CODEC;
    }

    protected GrowingPlantHeadBlock getHeadBlock() {
        return (GrowingPlantHeadBlock)BOPBlocks.LUMALOOP;
    }

    public boolean canSurvive(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        BlockPos blockpos = p_196260_3_.relative(this.growthDirection.getOpposite());
        BlockState blockstate = p_196260_2_.getBlockState(blockpos);
        Block block = blockstate.getBlock();
        if (!this.canAttachTo(blockstate)) {
            return false;
        }
        return block == this.getHeadBlock() || block == this.getBodyBlock() || block == Blocks.END_STONE || block == BOPBlocks.UNMAPPED_END_STONE || block == BOPBlocks.NULL_END_STONE || block == BOPBlocks.ALGAL_END_STONE;
    }

    public static ToIntFunction<BlockState> lightLevel(int level) {
        return state -> (Boolean)state.getValue((Property)LIT) != false ? level : 0;
    }

    protected BlockState updateHeadAfterConvertedFromBody(BlockState $$0, BlockState $$1) {
        return (BlockState)$$1.setValue((Property)LIT, (Comparable)((Boolean)$$0.getValue((Property)LIT)));
    }

    public void performBonemeal(ServerLevel $$0, RandomSource $$1, BlockPos $$2, BlockState $$3) {
        $$0.setBlock($$2, (BlockState)$$3.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_56651_) {
        p_56651_.add(new Property[]{LIT});
    }
}

