/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.requirement;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.blay09.mods.waystones.client.requirement.CombinedRequirementRenderer;
import net.blay09.mods.waystones.client.requirement.CooldownRequirementRenderer;
import net.blay09.mods.waystones.client.requirement.ExperienceLevelRequirementRenderer;
import net.blay09.mods.waystones.client.requirement.ExperiencePointsRequirementRenderer;
import net.blay09.mods.waystones.client.requirement.ItemRequirementRenderer;
import net.blay09.mods.waystones.client.requirement.RefuseRequirementRenderer;
import net.blay09.mods.waystones.client.requirement.RequirementRenderer;
import net.blay09.mods.waystones.requirement.CombinedRequirement;
import net.blay09.mods.waystones.requirement.CooldownRequirement;
import net.blay09.mods.waystones.requirement.ExperienceLevelRequirement;
import net.blay09.mods.waystones.requirement.ExperiencePointsRequirement;
import net.blay09.mods.waystones.requirement.ItemRequirement;
import net.blay09.mods.waystones.requirement.RefuseRequirement;

public class RequirementClientRegistry {
    private static final Map<Class<? extends WarpRequirement>, RequirementRenderer<?>> renderers = new HashMap();

    public static <T extends WarpRequirement> void registerRenderer(Class<T> displayClass, RequirementRenderer<T> renderer) {
        renderers.put(displayClass, renderer);
    }

    public static <T extends WarpRequirement> RequirementRenderer<T> getRenderer(Class<T> displayClass) {
        return renderers.get(displayClass);
    }

    public static <T extends WarpRequirement> RequirementRenderer<T> getRenderer(T requirement) {
        return renderers.get(requirement.getClass());
    }

    public static void registerDefaults() {
        RequirementClientRegistry.registerRenderer(CooldownRequirement.class, new CooldownRequirementRenderer());
        RequirementClientRegistry.registerRenderer(ExperienceLevelRequirement.class, new ExperienceLevelRequirementRenderer());
        RequirementClientRegistry.registerRenderer(ExperiencePointsRequirement.class, new ExperiencePointsRequirementRenderer());
        RequirementClientRegistry.registerRenderer(ItemRequirement.class, new ItemRequirementRenderer());
        RequirementClientRegistry.registerRenderer(RefuseRequirement.class, new RefuseRequirementRenderer());
        RequirementClientRegistry.registerRenderer(CombinedRequirement.class, new CombinedRequirementRenderer());
    }
}

