/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.item;

import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MailboxItem
extends BlockItem {
    public MailboxItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DeliveryService service = DeliveryService.get(player2.server).orElse(null);
            if (service != null) {
                if (!service.canCreateMailbox((Player)player2)) {
                    int maxCount = (Integer)Config.SERVER.mailing.maxMailboxesPerPlayer.get();
                    player2.sendSystemMessage(Components.GUI_MAIL_BOX_LIMIT.apply(maxCount), true);
                    return false;
                }
                return super.canPlace(context, state);
            }
        }
        return super.canPlace(context, state);
    }
}

