/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeSerializers;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.data.Material;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WorkbenchContructingRecipe
implements Recipe<SingleRecipeInput> {
    private final NonNullList<StackedIngredient> materials;
    private final ItemStack result;
    private final boolean notification;

    public WorkbenchContructingRecipe(NonNullList<StackedIngredient> materials, ItemStack result, boolean notification) {
        this.materials = materials;
        this.result = result;
        this.notification = notification;
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.WORKBENCH_CONSTRUCTING.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.WORKBENCH_RECIPE.get();
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return true;
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public boolean showNotification() {
        return this.notification;
    }

    public NonNullList<StackedIngredient> getMaterials() {
        return this.materials;
    }

    public int getResultId() {
        return Item.getId((Item)this.result.getItem());
    }

    public ItemStack getResult() {
        return this.result;
    }

    public static Builder builder(ItemLike result, int count, Function<ItemLike, Criterion<?>> hasItem, Function<TagKey<Item>, Criterion<?>> hasTag) {
        return new Builder(result.asItem(), count, hasItem, hasTag);
    }

    public static class Builder
    implements RecipeBuilder {
        private final Item result;
        private final int count;
        private final Function<ItemLike, Criterion<?>> hasItem;
        private final Function<TagKey<Item>, Criterion<?>> hasTag;
        private final NonNullList<StackedIngredient> materials = NonNullList.create();
        private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
        private RecipeCategory category = RecipeCategory.MISC;
        private boolean showNotification;

        private Builder(Item result, int count, Function<ItemLike, Criterion<?>> hasItem, Function<TagKey<Item>, Criterion<?>> hasTag) {
            this.result = result;
            this.count = count;
            this.hasItem = hasItem;
            this.hasTag = hasTag;
        }

        public Builder requiresMaterial(Material<?> material) {
            this.materials.add((Object)material.asStackedIngredient());
            return this.unlockedBy("has_" + material.getName(), (Criterion)material.createTrigger(this.hasItem, this.hasTag));
        }

        public Builder unlockedBy(String name, Criterion<?> trigger) {
            this.criteria.put(name, trigger);
            return this;
        }

        public Builder group(@Nullable String group) {
            return this;
        }

        public Builder category(RecipeCategory category) {
            this.category = category;
            return this;
        }

        public Builder showNotification(boolean show) {
            this.showNotification = show;
            return this;
        }

        public Item getResult() {
            return this.result;
        }

        public void save(RecipeOutput output, ResourceLocation id) {
            this.validate(id);
            Advancement.Builder builder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
            output.accept(id, (Recipe)new WorkbenchContructingRecipe(this.materials, new ItemStack((ItemLike)this.result), this.showNotification), builder.build(id.withPrefix("recipes/" + this.category.getFolderName() + "/")));
        }

        private void validate(ResourceLocation id) {
            if (this.materials.isEmpty()) {
                throw new IllegalArgumentException("There must be at least one material for workbench crafting recipe %s".formatted(id));
            }
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<WorkbenchContructingRecipe> {
        public static final MapCodec<WorkbenchContructingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)StackedIngredient.CODEC.listOf().fieldOf("materials").flatXmap(materials -> {
            Object[] inputs = (StackedIngredient[])materials.stream().filter(ingredient -> !ingredient.ingredient().isEmpty() || ingredient.count() <= 0).toArray(StackedIngredient[]::new);
            return DataResult.success((Object)NonNullList.of((Object)StackedIngredient.EMPTY, (Object[])inputs));
        }, DataResult::success).forGetter(o -> o.materials), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)false).forGetter(recipe -> recipe.notification)).apply((Applicative)builder, WorkbenchContructingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WorkbenchContructingRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            buf.writeInt(recipe.materials.size());
            recipe.materials.forEach(ingredient -> ingredient.toNetwork((RegistryFriendlyByteBuf)buf));
            ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.result);
            buf.writeBoolean(recipe.notification);
        }, buf -> {
            int materialCount = buf.readInt();
            NonNullList materials = NonNullList.withSize((int)materialCount, (Object)StackedIngredient.EMPTY);
            IntStream.range(0, materialCount).forEach(i -> materials.set(i, (Object)StackedIngredient.fromNetwork(buf)));
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            boolean notification = buf.readBoolean();
            return new WorkbenchContructingRecipe((NonNullList<StackedIngredient>)materials, result, notification);
        });

        public MapCodec<WorkbenchContructingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WorkbenchContructingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

