/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client.graphics;

import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.computer.app.HomeControl;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.Scene;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerSelectionList;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageHomeControl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class HomeControlGraphics
extends DisplayableProgram<HomeControl> {
    public HomeControlGraphics(HomeControl program) {
        super(program, 200, 100);
        this.setScene(new Home(this));
    }

    public static class Home
    extends Scene {
        private final HomeControlGraphics graphics;
        private final ComputerSelectionList<DeviceItem> devices;
        private final ComputerButton turnOnAllButton;
        private final ComputerButton turnOffAllButton;
        private final ComputerButton infoButton;

        public Home(HomeControlGraphics graphics) {
            this.graphics = graphics;
            this.devices = this.addWidget(new ComputerSelectionList(graphics.getWidth() - 10, graphics.getHeight() - 30, 25, 100, 16));
            ((HomeControl)graphics.getProgram()).findDevices().forEach(device -> this.devices.children().add(new DeviceItem((IHomeControlDevice)device)));
            this.turnOnAllButton = this.addWidget(new ComputerButton(60, 14, graphics.translation("turn_on_all"), btn -> Network.getPlay().sendToServer((Object)new MessageHomeControl.UpdateAll(true))));
            this.turnOnAllButton.setTextColour(-13147337);
            this.turnOnAllButton.setTextHighlightColour(-13147337);
            this.turnOnAllButton.setOutlineColour(-14540251);
            this.turnOnAllButton.setBackgroundHighlightColour(-13423059);
            this.turnOffAllButton = this.addWidget(new ComputerButton(60, 14, graphics.translation("turn_off_all"), btn -> Network.getPlay().sendToServer((Object)new MessageHomeControl.UpdateAll(false))));
            this.turnOffAllButton.setTextColour(-10143432);
            this.turnOffAllButton.setTextHighlightColour(-10143432);
            this.turnOffAllButton.setOutlineColour(-14540251);
            this.turnOffAllButton.setBackgroundHighlightColour(-13423059);
            this.infoButton = this.addWidget(new ComputerButton(13, 14, (Component)Component.literal((String)"i"), btn -> graphics.setScene(new Info(graphics))));
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.devices.setPosition(contentStart + 5, contentTop + 25);
            this.turnOnAllButton.setPosition(contentStart + 5, contentTop + 3);
            this.turnOffAllButton.setPosition(contentStart + 5 + this.turnOnAllButton.getWidth() + 2, contentTop + 3);
            this.infoButton.setPosition(contentStart + this.graphics.getWidth() - 5 - this.infoButton.getWidth(), contentTop + 3);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.fill(0, 0, this.graphics.getWidth(), 20, -14277082);
        }
    }

    private static class DeviceItem
    extends ObjectSelectionList.Entry<DeviceItem> {
        private final IHomeControlDevice device;
        private final ComputerButton button;

        public DeviceItem(IHomeControlDevice device) {
            this.device = device;
            this.button = new ComputerButton(50, 14, (Component)Component.literal((String)"Toggle"), btn -> Network.getPlay().sendToServer((Object)new MessageHomeControl.Toggle(this.device.getDevicePos())));
            this.button.setBackgroundHighlightColour(-13423059);
            this.updateButtonLabel();
        }

        private void updateButtonLabel() {
            this.button.setMessage(this.device.isDeviceEnabled() ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF);
            this.button.setTextColour(this.device.isDeviceEnabled() ? -13147337 : -10143432);
            this.button.setTextHighlightColour(this.device.isDeviceEnabled() ? -13147337 : -10143432);
        }

        public void renderBack(GuiGraphics $$0, int $$1, int $$2, int $$3, int $$4, int $$5, int $$6, int $$7, boolean $$8, float $$9) {
            super.renderBack($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7, $$8, $$9);
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
            this.updateButtonLabel();
            graphics.fill(left, top, left + rowWidth, top + rowHeight, -12107714);
            graphics.drawString(Minecraft.getInstance().font, this.device.getDeviceName(), left + 5, top + 4, -14540251, false);
            this.button.setPosition(left + rowWidth - this.button.getWidth() - 1, top + 1);
            this.button.render(graphics, mouseX, mouseY, partialTick);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.button.mouseClicked(mouseX, mouseY, button);
            return true;
        }

        public Component getNarration() {
            return this.device.getDeviceName();
        }
    }

    public static class Info
    extends Scene {
        private final HomeControlGraphics graphics;
        private final ComputerButton backButton;
        private final Component infoText;

        public Info(HomeControlGraphics graphics) {
            this.graphics = graphics;
            this.backButton = this.addWidget(new ComputerButton(14, 14, (Component)Component.literal((String)"<"), btn -> graphics.setScene(new Home(graphics))));
            this.infoText = graphics.translation("info");
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.backButton.setPosition(contentStart + 5, contentTop + 3);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.fill(0, 0, this.graphics.getWidth(), 20, -14277082);
            graphics.drawWordWrap(Minecraft.getInstance().font, (FormattedText)this.infoText, 5, 25, this.graphics.getWidth() - 10, -12107714);
        }
    }
}

