/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.util;

import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class ScreenHelper {
    public static Tooltip createMultilineTooltip(List<Component> lines) {
        if (!lines.isEmpty()) {
            Tooltip tooltip = Tooltip.create((Component)lines.get(0));
            List<FormattedCharSequence> sequences = lines.stream().map(c -> Minecraft.getInstance().font.split((FormattedText)c, 170)).flatMap(Collection::stream).toList();
            ClientServices.PLATFORM.setTooltipCache(tooltip, sequences);
            return tooltip;
        }
        return Tooltip.create((Component)CommonComponents.EMPTY);
    }

    public static List<MutableComponent> splitText(String text, int maxWidth) {
        return Minecraft.getInstance().font.getSplitter().splitLines(text, maxWidth, Style.EMPTY).stream().map(t -> Component.literal((String)t.getString())).collect(Collectors.toList());
    }

    public static boolean isMouseWithinBounds(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    public static void fillRounded(GuiGraphics graphics, int x, int y, int width, int height, int colour) {
        graphics.fill(x, y + 1, x + 1, y + height - 1, colour);
        graphics.fill(x + 1, y, x + width - 1, y + height, colour);
        graphics.fill(x + width - 1, y + 1, x + width, y + height - 1, colour);
    }
}

