/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.WorkbenchScreen;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import java.util.HashMap;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;

public class ClientWorkbenchRecipeTooltip
implements ClientTooltipComponent {
    private final WorkbenchMenu menu;
    private final WorkbenchContructingRecipe recipe;

    public ClientWorkbenchRecipeTooltip(WorkbenchMenu menu, WorkbenchContructingRecipe recipe) {
        this.menu = menu;
        this.recipe = recipe;
    }

    public int getHeight() {
        return 20;
    }

    public int getWidth(Font font) {
        return this.recipe.getMaterials().size() * 18;
    }

    public void renderImage(Font font, int start, int top, GuiGraphics graphics) {
        HashMap<Integer, Integer> counted = new HashMap<Integer, Integer>();
        NonNullList<StackedIngredient> materials = this.recipe.getMaterials();
        for (int i = 0; i < materials.size(); ++i) {
            StackedIngredient material = (StackedIngredient)materials.get(i);
            ItemStack copy = this.getStack(material).copy();
            copy.setCount(material.count());
            graphics.renderFakeItem(copy, start + i * 18, top);
            graphics.renderItemDecorations(font, copy, start + i * 18, top);
            PoseStack pose = graphics.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 200.0f);
            boolean checked = this.menu.hasMaterials(material, counted);
            graphics.blit(WorkbenchScreen.WORKBENCH_TEXTURE, start + i * 18, top, checked ? 246 : 240, 40, 6, 5);
            pose.popPose();
        }
    }

    private ItemStack getStack(StackedIngredient material) {
        ItemStack[] items = material.ingredient().getItems();
        int index = (int)(Util.getMillis() / 1000L % (long)items.length);
        return items[index];
    }
}

