/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.framework.api.event.ClientConnectionEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.ScreenEvents;
import com.mrcrayfish.framework.event.IClientConnectionEvent;
import com.mrcrayfish.framework.event.IScreenEvent;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.core.ModCreativeTabs;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class CreativeFilters {
    private static final ResourceLocation SELECTED_FILTER_TAB = Utils.resource("filter_tab_selected");
    private static final ResourceLocation UNSELECTED_FILTER_TAB = Utils.resource("filter_tab_unselected");
    private static CreativeFilters instance;
    private final List<FilterCategory> categories;
    private AbstractWidget scrollUpButton;
    private AbstractWidget scrollDownButton;
    private CreativeModeTab lastTab;
    private int guiLeft;
    private int guiTop;
    private int scroll;

    public static CreativeFilters get() {
        if (instance == null) {
            instance = new CreativeFilters();
        }
        return instance;
    }

    private CreativeFilters() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new FilterCategory(ModTags.Items.GENERAL, new ItemStack((ItemLike)ModBlocks.CHAIR_OAK.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.BEDROOM, new ItemStack((ItemLike)ModBlocks.DRAWER_CHERRY.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.KITCHEN, new ItemStack((ItemLike)ModBlocks.KITCHEN_SINK_YELLOW.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.OUTDOORS, new ItemStack((ItemLike)ModBlocks.GRILL_RED.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.BATHROOM, new ItemStack((ItemLike)ModBlocks.TOILET_OAK.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.ELECTRONICS, new ItemStack((ItemLike)ModBlocks.ELECTRICITY_GENERATOR_LIGHT.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.STORAGE, new ItemStack((ItemLike)ModBlocks.CRATE_BIRCH.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.FOOD, new ItemStack((ItemLike)ModItems.SWEET_BERRY_JAM_TOAST.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.ITEMS, new ItemStack((ItemLike)ModItems.SPATULA.get())));
        this.categories = builder.build();
        ScreenEvents.MODIFY_WIDGETS.register((IFrameworkEvent)((IScreenEvent.ModifyWidgets)(screen, widgets, add, remove) -> {
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
                this.guiLeft = ClientServices.PLATFORM.getGuiLeft((AbstractContainerScreen<?>)creativeScreen);
                this.guiTop = ClientServices.PLATFORM.getGuiTop((AbstractContainerScreen<?>)creativeScreen);
                this.categories.forEach(FilterCategory::loadItems);
                this.injectWidgets(creativeScreen, add);
            }
        }));
        ScreenEvents.CLOSED.register((IFrameworkEvent)((IScreenEvent.Closed)screen -> {
            if (screen instanceof CreativeModeInventoryScreen) {
                this.categories.forEach(category -> {
                    this.scrollUpButton = null;
                    this.scrollDownButton = null;
                    category.setFilterTab(null);
                });
            }
        }));
        ScreenEvents.AFTER_DRAW.register((IFrameworkEvent)((IScreenEvent.AfterDraw)(screen, graphics, mouseX, mouseY, partialTick) -> {
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
                CreativeModeTab tab = ClientServices.PLATFORM.getSelectedCreativeModeTab();
                if (this.lastTab != tab) {
                    this.onSwitchCreativeTab(tab, creativeScreen);
                    this.lastTab = tab;
                }
                this.drawFilterTabTooltips(graphics, mouseX, mouseY);
            }
        }));
        ClientConnectionEvents.LOGGING_OUT.register((IFrameworkEvent)((IClientConnectionEvent.LoggingOut)player -> this.categories.forEach(category -> {
            category.resetItems();
            category.setEnabled(true);
        })));
    }

    private void injectWidgets(CreativeModeInventoryScreen screen, Consumer<AbstractWidget> add) {
        this.categories.forEach(category -> {
            FilterTab tab = new FilterTab(this.guiLeft - 28, this.guiTop, (FilterCategory)category, btn -> {
                if (Screen.hasControlDown() || Screen.hasShiftDown()) {
                    category.setEnabled(!category.isEnabled());
                } else {
                    this.categories.forEach(c -> c.setEnabled(false));
                    category.setEnabled(true);
                }
                this.updateItems(screen);
            });
            tab.visible = false;
            add.accept((AbstractWidget)tab);
        });
        this.scrollUpButton = new IconButton(this.guiLeft - 22, this.guiTop - 12, 0, 0, btn -> {
            if (this.scroll > 0) {
                --this.scroll;
            }
            this.updateWidgets();
        });
        add.accept(this.scrollUpButton);
        this.scrollDownButton = new IconButton(this.guiLeft - 22, this.guiTop + 127, 10, 0, btn -> {
            if (this.scroll <= this.categories.size() - 4 - 1) {
                ++this.scroll;
            }
            this.updateWidgets();
        });
        add.accept(this.scrollDownButton);
        this.updateWidgets();
        this.onSwitchCreativeTab(ClientServices.PLATFORM.getSelectedCreativeModeTab(), screen);
    }

    private void updateItems(CreativeModeInventoryScreen screen) {
        HashSet seenItems = new HashSet();
        LinkedHashSet categorisedItems = new LinkedHashSet();
        ((CreativeModeTab)ModCreativeTabs.MAIN.get()).getDisplayItems().forEach(stack -> this.categories.stream().filter(FilterCategory::isEnabled).forEach(category -> {
            Item item = stack.getItem();
            if (!seenItems.contains(item) && stack.is(category.tag)) {
                categorisedItems.add(stack.copy());
                seenItems.add(item);
            }
        }));
        NonNullList items = ((CreativeModeInventoryScreen.ItemPickerMenu)screen.getMenu()).items;
        items.clear();
        items.addAll(categorisedItems);
        ((CreativeModeInventoryScreen.ItemPickerMenu)screen.getMenu()).scrollTo(0.0f);
    }

    private void updateWidgets() {
        this.categories.forEach(category -> category.setVisible(false));
        for (int i = this.scroll; i < this.scroll + 4 && i < this.categories.size(); ++i) {
            FilterCategory category2 = this.categories.get(i);
            category2.setY(this.guiTop + 29 * (i - this.scroll) + 11);
            category2.setVisible(true);
        }
        this.scrollUpButton.active = this.scroll > 0;
        this.scrollDownButton.active = this.scroll <= this.categories.size() - 4 - 1;
    }

    private void onSwitchCreativeTab(CreativeModeTab tab, CreativeModeInventoryScreen screen) {
        boolean isFurnitureTab;
        this.scrollUpButton.visible = isFurnitureTab = tab == ModCreativeTabs.MAIN.get();
        this.scrollDownButton.visible = isFurnitureTab;
        if (isFurnitureTab) {
            this.updateWidgets();
            this.updateItems(screen);
            return;
        }
        this.categories.forEach(category -> category.setVisible(false));
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double scroll) {
        CreativeModeTab selectedTab = ClientServices.PLATFORM.getSelectedCreativeModeTab();
        if (selectedTab != ModCreativeTabs.MAIN.get()) {
            return false;
        }
        double startX = this.guiLeft - 28;
        double startY = this.guiTop + 29;
        if (mouseX >= startX && mouseX < startX + 28.0 && mouseY >= startY && mouseY < startY + 113.0) {
            int oldScroll = this.scroll;
            this.scroll += scroll > 0.0 ? -1 : 1;
            this.scroll = Mth.clamp((int)this.scroll, (int)0, (int)(this.categories.size() - 4));
            if (this.scroll != oldScroll) {
                this.updateWidgets();
            }
            return true;
        }
        return false;
    }

    private void drawFilterTabTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        for (FilterCategory category : this.categories) {
            FilterTab tab = category.filterTab;
            if (!tab.visible || !tab.isHovered()) continue;
            Minecraft mc = Minecraft.getInstance();
            graphics.renderTooltip(mc.font, tab.cachedTooltip.toCharSequence(mc), mouseX, mouseY);
            return;
        }
    }

    public static class FilterCategory {
        private final TagKey<Item> tag;
        private final ItemStack icon;
        private List<Item> items;
        private boolean enabled = true;
        private FilterTab filterTab;

        public FilterCategory(TagKey<Item> tag, ItemStack icon) {
            this.tag = tag;
            this.icon = icon;
        }

        public TagKey<Item> getTag() {
            return this.tag;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public Optional<List<Item>> getItems() {
            return Optional.ofNullable(this.items);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setFilterTab(@Nullable FilterTab filterTab) {
            this.filterTab = filterTab;
        }

        public void setVisible(boolean visible) {
            if (this.filterTab != null) {
                this.filterTab.visible = visible;
            }
        }

        public void setY(int y) {
            if (this.filterTab != null) {
                this.filterTab.setY(y);
            }
        }

        public void loadItems() {
            if (this.items != null) {
                return;
            }
            this.items = new ArrayList<Item>();
            BuiltInRegistries.ITEM.stream().forEach(item -> {
                if (item.builtInRegistryHolder().is(this.getTag())) {
                    this.items.add((Item)item);
                }
            });
        }

        public void resetItems() {
            this.items = null;
        }
    }

    private static class FilterTab
    extends Button {
        private final FilterCategory category;
        private final Tooltip cachedTooltip;

        protected FilterTab(int x, int y, FilterCategory category, Button.OnPress onPress) {
            super(x, y, 32, 26, CommonComponents.EMPTY, onPress, DEFAULT_NARRATION);
            this.category = category;
            category.setFilterTab(this);
            ResourceLocation tagId = category.getTag().location();
            String tooltipTitle = String.format("filterCategory.%s.%s", tagId.getNamespace(), tagId.getPath().replace("/", "."));
            String tooltipDesc = tooltipTitle + ".desc";
            this.cachedTooltip = ScreenHelper.createMultilineTooltip(List.of(Component.translatable((String)tooltipTitle), Component.translatable((String)tooltipDesc).withStyle(ChatFormatting.GRAY)));
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.blitSprite(this.category.isEnabled() ? SELECTED_FILTER_TAB : UNSELECTED_FILTER_TAB, this.getX(), this.getY(), 32, 26);
            graphics.renderItem(this.category.getIcon(), this.getX() + 8, this.getY() + 5);
        }
    }
}

